/*
 * Decompiled with CFR 0.152.
 */
package com.neuromd.neurosdk;

import com.neuromd.neurosdk.AnyChannel;
import com.neuromd.neurosdk.AnyChannelLengthChangedCallback;
import com.neuromd.neurosdk.BaseDoubleChannel;
import com.neuromd.neurosdk.ChannelInfo;
import com.neuromd.neurosdk.Device;
import com.neuromd.neurosdk.DoubleDataChannel;

public class EcgChannel
extends BaseDoubleChannel {
    private final Device mDevice;
    private final AnyChannel mAnyChannel;
    private final DoubleDataChannel mDataChannel;
    private final AnyChannelLengthChangedCallback lengthChangedCallback = new AnyChannelLengthChangedCallback(){

        @Override
        public void onDataLengthChanged(int dataLength) {
            EcgChannel.this.dataLengthChanged.sendNotification(this, dataLength);
        }
    };

    public EcgChannel(Device device) {
        this.mDevice = device;
        this.mAnyChannel = new AnyChannel(EcgChannel.createEcgDoubleChannel(device.devicePtr()), this.lengthChangedCallback);
        this.mDataChannel = new DoubleDataChannel(this.mAnyChannel);
    }

    public EcgChannel(Device device, ChannelInfo info) {
        this.mDevice = device;
        this.mAnyChannel = new AnyChannel(EcgChannel.createEcgDoubleChannelInfo(device.devicePtr(), info), this.lengthChangedCallback);
        this.mDataChannel = new DoubleDataChannel(this.mAnyChannel);
    }

    @Override
    public void close() {
        this.mAnyChannel.close();
    }

    @Override
    public ChannelInfo info() {
        return this.mAnyChannel.info();
    }

    @Override
    public int totalLength() {
        return this.mAnyChannel.totalLength();
    }

    public int bufferSize() {
        return EcgChannel.ecgDoubleChannelGetBufferSize(this.channelPtr());
    }

    @Override
    public float samplingFrequency() {
        return this.mAnyChannel.samplingFrequency();
    }

    @Override
    public long channelPtr() {
        return this.mAnyChannel.channelPtr();
    }

    @Override
    public double[] readData(int offset, int length) {
        return this.mDataChannel.readData(offset, length);
    }

    private static native long createEcgDoubleChannel(long var0);

    private static native long createEcgDoubleChannelInfo(long var0, ChannelInfo var2);

    private static native int ecgDoubleChannelGetBufferSize(long var0);

    static {
        System.loadLibrary("android-neurosdk");
    }
}

