/*
 * Decompiled with CFR 0.152.
 */
package com.neuromd.neurosdk;

import android.content.Context;
import com.neuromd.neurosdk.Device;
import com.neuromd.neurosdk.DeviceInfo;
import com.neuromd.neurosdk.DeviceType;
import com.neuromd.neurosdk.EventListener;
import com.neuromd.neurosdk.SubscribersNotifier;
import java.util.List;

public class DeviceEnumerator {
    private boolean mIsClosed = false;
    private final EventListener mEventListener;
    private final long mEnumeratorPtr;
    private final long mDeviceListChangedListenerPtr;
    public final SubscribersNotifier deviceListChanged = new SubscribersNotifier();

    public DeviceEnumerator(Context context, DeviceType deviceType) {
        this.mEventListener = new EventListener(new EventListener.Callback(){

            @Override
            public void onEvent() {
                DeviceEnumerator.this.deviceListChanged.sendNotification(this, null);
            }
        });
        this.mEnumeratorPtr = DeviceEnumerator.createDeviceEnumerator(context, deviceType);
        this.mDeviceListChangedListenerPtr = DeviceEnumerator.enumeratorSetDeviceListChangedCallback(this.mEnumeratorPtr, this.mEventListener.queuePtr());
    }

    public void finalize() throws Throwable {
        if (!this.mIsClosed) {
            this.close();
        }
        super.finalize();
    }

    public void close() throws InterruptedException {
        if (this.mIsClosed) {
            return;
        }
        this.mIsClosed = true;
        DeviceEnumerator.enumeratorUnsubscribeDeviceListChanged(this.mDeviceListChangedListenerPtr);
        DeviceEnumerator.enumeratorDelete(this.mEnumeratorPtr);
        this.mEventListener.close();
    }

    public List<DeviceInfo> devices() {
        this.throwIfClosed();
        return DeviceEnumerator.enumeratorGetDeviceList(this.mEnumeratorPtr);
    }

    public Device createDevice(DeviceInfo info) {
        this.throwIfClosed();
        return new Device(info, this.mEnumeratorPtr);
    }

    private void throwIfClosed() {
        if (this.mIsClosed) {
            throw new UnsupportedOperationException("DeviceEnumerator is closed");
        }
    }

    private static native long createDeviceEnumerator(Context var0, DeviceType var1);

    private static native void enumeratorDelete(long var0);

    private static native long enumeratorSetDeviceListChangedCallback(long var0, long var2);

    private static native List<DeviceInfo> enumeratorGetDeviceList(long var0);

    private static native void enumeratorUnsubscribeDeviceListChanged(long var0);

    static {
        System.loadLibrary("android-neurosdk");
    }
}

