/*
 * Decompiled with CFR 0.152.
 */
package com.neuromd.neurosdk;

import com.neuromd.neurosdk.Assert;
import com.neuromd.neurosdk.ChannelInfo;
import com.neuromd.neurosdk.Command;
import com.neuromd.neurosdk.DeviceInfo;
import com.neuromd.neurosdk.INotificationCallback;
import com.neuromd.neurosdk.Parameter;
import com.neuromd.neurosdk.ParameterEventListener;
import com.neuromd.neurosdk.ParameterName;
import com.neuromd.neurosdk.ParameterTypeInfo;
import com.neuromd.neurosdk.SubscribersNotifier;
import java.util.Hashtable;

public class Device {
    private boolean mIsClosed = false;
    private final ParameterEventListener mParameterListener;
    private final long mParamChangedListenerPtr;
    private final Hashtable<INotificationCallback<DoubleChannelData>, Long> mDoubleChannelListenerHandles = new Hashtable();
    private final Hashtable<INotificationCallback<IntChannelData>, Long> mIntChannelListenerHandles = new Hashtable();
    private final SubscribersNotifier<DoubleChannelData> mDoubleChannelDataReceived = new SubscribersNotifier();
    private final SubscribersNotifier<IntChannelData> mIntChannelDataReceived = new SubscribersNotifier();
    private final long mDevicePtr;
    public final SubscribersNotifier<ParameterName> parameterChanged = new SubscribersNotifier();

    Device(DeviceInfo info, long enumeratorPtr) {
        this.mDevicePtr = Device.createDevice(info, enumeratorPtr);
        Assert.expects(this.mDevicePtr != 0L, "Device pointer is null");
        this.mParameterListener = new ParameterEventListener(new ParameterEventListener.Callback(){

            @Override
            public void onEvent(ParameterName parameter) {
                Device.this.parameterChanged.sendNotification(this, parameter);
            }
        });
        this.mParamChangedListenerPtr = Device.deviceSubscribeParamChanged(this.mDevicePtr, this.mParameterListener.queuePtr());
    }

    public void finalize() throws Throwable {
        if (!this.mIsClosed) {
            this.close();
        }
        super.finalize();
    }

    public long devicePtr() {
        this.throwIfClosed();
        return this.mDevicePtr;
    }

    public void connect() {
        this.throwIfClosed();
        Device.deviceConnect(this.mDevicePtr);
    }

    public void disconnect() {
        this.throwIfClosed();
        Device.deviceDisconnect(this.mDevicePtr);
    }

    public ChannelInfo[] channels() {
        this.throwIfClosed();
        return Device.deviceAvailableChannels(this.mDevicePtr);
    }

    public Command[] commands() {
        this.throwIfClosed();
        return Device.deviceAvailableCommands(this.mDevicePtr);
    }

    public Parameter[] parameters() {
        this.throwIfClosed();
        return Device.deviceAvailableParameters(this.mDevicePtr);
    }

    public void execute(Command cmd) {
        this.throwIfClosed();
        Device.deviceExecute(this.mDevicePtr, cmd);
    }

    public <ParamType> ParamType readParam(ParameterName param) {
        this.throwIfClosed();
        ParameterTypeInfo paramTypeInfo = new ParameterTypeInfo(param);
        Object paramValue = paramTypeInfo.paramReader().readParam(this);
        return (ParamType)paramValue;
    }

    public boolean setParam(ParameterName param, Object value) {
        this.throwIfClosed();
        ParameterTypeInfo paramTypeInfo = new ParameterTypeInfo(param);
        paramTypeInfo.paramSetter().setParam(this, value);
        return true;
    }

    public void addDoubleChannelDataListener(INotificationCallback<DoubleChannelData> callback, ChannelInfo channelInfo) {
        this.throwIfClosed();
        if (callback == null) {
            return;
        }
        long listenerHandle = this.deviceSubscribeDoubleChannelDataReceived(this.mDevicePtr, channelInfo);
        Long previous = this.mDoubleChannelListenerHandles.put(callback, listenerHandle);
        if (previous != null) {
            Device.freeDoubleDataReceivedListenerHandle(previous);
        }
        this.mDoubleChannelDataReceived.subscribe(callback);
    }

    public void addIntChannelDataListener(INotificationCallback<IntChannelData> callback, ChannelInfo channelInfo) {
        this.throwIfClosed();
        if (callback == null) {
            return;
        }
        long listenerHandle = this.deviceSubscribeIntChannelDataReceived(this.mDevicePtr, channelInfo);
        Long previous = this.mIntChannelListenerHandles.put(callback, listenerHandle);
        if (previous != null) {
            Device.freeIntDataReceivedListenerHandle(previous);
        }
        this.mIntChannelDataReceived.subscribe(callback);
    }

    public void removeIntChannelDataListener(INotificationCallback<IntChannelData> callback) {
        this.throwIfClosed();
        if (this.mIntChannelListenerHandles.containsKey(callback)) {
            Device.freeIntDataReceivedListenerHandle(this.mIntChannelListenerHandles.get(callback));
            this.mIntChannelListenerHandles.remove(callback);
        }
    }

    public void removeDoubleChannelDataListener(INotificationCallback<DoubleChannelData> callback) {
        this.throwIfClosed();
        if (this.mDoubleChannelListenerHandles.containsKey(callback)) {
            Device.freeDoubleDataReceivedListenerHandle(this.mDoubleChannelListenerHandles.get(callback));
            this.mDoubleChannelListenerHandles.remove(callback);
        }
    }

    public void close() throws InterruptedException {
        if (this.mIsClosed) {
            return;
        }
        this.mIsClosed = true;
        this.removeAllCahnnelListeners();
        Device.freeParamListenerHandle(this.mParamChangedListenerPtr);
        this.mParameterListener.close();
        Device.deviceDelete(this.mDevicePtr);
    }

    private void removeAllCahnnelListeners() {
        for (long listener : this.mIntChannelListenerHandles.values()) {
            Device.freeIntDataReceivedListenerHandle(listener);
        }
        this.mIntChannelListenerHandles.clear();
        for (long listener : this.mDoubleChannelListenerHandles.values()) {
            Device.freeDoubleDataReceivedListenerHandle(listener);
        }
        this.mDoubleChannelListenerHandles.clear();
    }

    private void onDoubleDataReceived(long devicePtr, ChannelInfo info, double[] dataArray) {
        if (this.mIsClosed) {
            return;
        }
        if (this.mDevicePtr != devicePtr) {
            return;
        }
        this.mDoubleChannelDataReceived.sendNotification(this, new DoubleChannelData(dataArray, info));
    }

    private void onIntDataReceived(long devicePtr, ChannelInfo info, int[] dataArray) {
        if (this.mIsClosed) {
            return;
        }
        if (this.mDevicePtr != devicePtr) {
            return;
        }
        this.mIntChannelDataReceived.sendNotification(this, new IntChannelData(dataArray, info));
    }

    private void throwIfClosed() {
        if (this.mIsClosed) {
            throw new UnsupportedOperationException("Device is closed");
        }
    }

    private static native void freeParamListenerHandle(long var0);

    private static native void freeDoubleDataReceivedListenerHandle(long var0);

    private static native void freeIntDataReceivedListenerHandle(long var0);

    private static native long createDevice(DeviceInfo var0, long var1);

    private static native void deviceConnect(long var0);

    private static native void deviceDisconnect(long var0);

    private static native void deviceDelete(long var0);

    private static native ChannelInfo[] deviceAvailableChannels(long var0);

    private static native Command[] deviceAvailableCommands(long var0);

    private static native Parameter[] deviceAvailableParameters(long var0);

    private static native void deviceExecute(long var0, Command var2);

    private static native long deviceSubscribeParamChanged(long var0, long var2);

    private native long deviceSubscribeDoubleChannelDataReceived(long var1, ChannelInfo var3);

    private native long deviceSubscribeIntChannelDataReceived(long var1, ChannelInfo var3);

    static {
        System.loadLibrary("android-neurosdk");
    }

    public class IntChannelData {
        private final ChannelInfo mChannelInfo;
        private final int[] mDataArray;

        public ChannelInfo channelInfo() {
            return this.mChannelInfo;
        }

        public int[] dataArray() {
            return this.mDataArray;
        }

        public IntChannelData(int[] array, ChannelInfo info) {
            this.mDataArray = array;
            this.mChannelInfo = info;
        }
    }

    public class DoubleChannelData {
        private final ChannelInfo mChannelInfo;
        private final double[] mDataArray;

        public ChannelInfo channelInfo() {
            return this.mChannelInfo;
        }

        public double[] dataArray() {
            return this.mDataArray;
        }

        public DoubleChannelData(double[] array, ChannelInfo info) {
            this.mDataArray = array;
            this.mChannelInfo = info;
        }
    }
}

