/*
 * Decompiled with CFR 0.152.
 */
package com.neuromd.neurosdk;

import com.neuromd.neurosdk.AnyChannel;
import com.neuromd.neurosdk.AnyChannelLengthChangedCallback;
import com.neuromd.neurosdk.BaseChannel;
import com.neuromd.neurosdk.BrainbitSyncData;
import com.neuromd.neurosdk.ChannelInfo;
import com.neuromd.neurosdk.Device;

public class BrainbitSyncChannel
extends BaseChannel {
    private final Device mDevice;
    private final AnyChannel mAnyChannel;
    private final AnyChannelLengthChangedCallback lengthChangedCallback = new AnyChannelLengthChangedCallback(){

        @Override
        public void onDataLengthChanged(int dataLength) {
            BrainbitSyncChannel.this.dataLengthChanged.sendNotification(this, dataLength);
        }
    };

    public BrainbitSyncChannel(Device device) {
        this.mDevice = device;
        this.mAnyChannel = new AnyChannel(BrainbitSyncChannel.createBrainbitSyncChannel(device.devicePtr()), this.lengthChangedCallback);
    }

    @Override
    public void close() {
        this.mAnyChannel.close();
    }

    @Override
    public ChannelInfo info() {
        return this.mAnyChannel.info();
    }

    @Override
    public int totalLength() {
        return this.mAnyChannel.totalLength();
    }

    public int bufferSize() {
        return BrainbitSyncChannel.getBufferSize(this.channelPtr());
    }

    @Override
    public float samplingFrequency() {
        return this.mAnyChannel.samplingFrequency();
    }

    @Override
    public long channelPtr() {
        return this.mAnyChannel.channelPtr();
    }

    public BrainbitSyncData[] readData(int offset, int length) {
        return BrainbitSyncChannel.readData(this.mAnyChannel.channelPtr(), offset, length);
    }

    private static native long createBrainbitSyncChannel(long var0);

    private static native int getBufferSize(long var0);

    private static native BrainbitSyncData[] readData(long var0, int var2, int var3);

    static {
        System.loadLibrary("android-neurosdk");
    }
}

