/*
 * Decompiled with CFR 0.152.
 */
package com.neuromd.neurosdk;

import com.neuromd.neurosdk.AnyChannel;
import com.neuromd.neurosdk.AnyChannelLengthChangedCallback;
import com.neuromd.neurosdk.BaseChannel;
import com.neuromd.neurosdk.ChannelInfo;
import com.neuromd.neurosdk.Device;
import com.neuromd.neurosdk.IntDataChannel;

public class BatteryChannel
extends BaseChannel {
    private final Device mDevice;
    private final AnyChannel mAnyChannel;
    private final IntDataChannel mDataChannel;
    private final AnyChannelLengthChangedCallback lengthChangedCallback = new AnyChannelLengthChangedCallback(){

        @Override
        public void onDataLengthChanged(int dataLength) {
            BatteryChannel.this.dataLengthChanged.sendNotification(this, dataLength);
        }
    };

    public BatteryChannel(Device device) {
        this.mDevice = device;
        this.mAnyChannel = new AnyChannel(BatteryChannel.createBatteryIntChannel(device.devicePtr()), this.lengthChangedCallback);
        this.mDataChannel = new IntDataChannel(this.mAnyChannel);
    }

    @Override
    public void close() {
        this.mAnyChannel.close();
    }

    @Override
    public ChannelInfo info() {
        return this.mAnyChannel.info();
    }

    @Override
    public int totalLength() {
        return this.mAnyChannel.totalLength();
    }

    public int bufferSize() {
        return BatteryChannel.BatteryIntChannelGetBufferSize(this.channelPtr());
    }

    @Override
    public float samplingFrequency() {
        return this.mAnyChannel.samplingFrequency();
    }

    @Override
    public long channelPtr() {
        return this.mAnyChannel.channelPtr();
    }

    public int[] readData(int offset, int length) {
        return this.mDataChannel.readData(offset, length);
    }

    private static native long createBatteryIntChannel(long var0);

    private static native int BatteryIntChannelGetBufferSize(long var0);

    static {
        System.loadLibrary("android-neurosdk");
    }
}

