/*
 * Decompiled with CFR 0.152.
 */
package com.neuromd.neurosdk;

import com.neuromd.neurosdk.AnyChannelLengthChangedCallback;
import com.neuromd.neurosdk.ChannelInfo;
import com.neuromd.neurosdk.LengthEventListener;

final class AnyChannel {
    private boolean mIsClosed = false;
    private final AnyChannelLengthChangedCallback mLengthChangedCallback;
    private final LengthEventListener mLengthListener;
    private final long mListenerPtr;
    private final long mChannelPtr;

    public long channelPtr() {
        this.throwIfClosed();
        return this.mChannelPtr;
    }

    public ChannelInfo info() {
        this.throwIfClosed();
        return AnyChannel.AnyChannelGetInfo(this.mChannelPtr);
    }

    public int totalLength() {
        this.throwIfClosed();
        return AnyChannel.AnyChannelGetTotalLength(this.mChannelPtr);
    }

    public float samplingFrequency() {
        this.throwIfClosed();
        return AnyChannel.AnyChannelGetSamplingFrequency(this.mChannelPtr);
    }

    public AnyChannel(long channelPtr, AnyChannelLengthChangedCallback lengthCallback) {
        if (channelPtr == 0L) {
            throw new IllegalArgumentException("Channel pointer is null");
        }
        this.mChannelPtr = channelPtr;
        this.mLengthChangedCallback = lengthCallback;
        this.mLengthListener = new LengthEventListener(new LengthEventListener.Callback(){

            @Override
            public void onEvent(int length) {
                AnyChannel.this.mLengthChangedCallback.onDataLengthChanged(length);
            }
        });
        this.mListenerPtr = AnyChannel.AnyChannelSubscribeLengthChanged(this.mChannelPtr, this.mLengthListener.queuePtr());
    }

    public void close() {
        if (!this.mIsClosed) {
            this.mIsClosed = true;
            AnyChannel.freeListenerHandle(this.mListenerPtr);
            try {
                this.mLengthListener.close();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            AnyChannel.AnyChannelDelete(this.mChannelPtr);
        }
    }

    private void throwIfClosed() {
        if (this.mIsClosed) {
            throw new UnsupportedOperationException("Channel is closed");
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private static native void freeListenerHandle(long var0);

    private static native void AnyChannelDelete(long var0);

    private static native ChannelInfo AnyChannelGetInfo(long var0);

    private static native float AnyChannelGetSamplingFrequency(long var0);

    private static native long AnyChannelSubscribeLengthChanged(long var0, long var2);

    private static native int AnyChannelGetTotalLength(long var0);
}

