package com.neuromd.neurosdk;

public class EmotionalStateChannel extends BaseChannel {
    static {
        System.loadLibrary("android-neurosdk");
    }

	private final AnyChannel mAnyChannel;

    //store source channels reference to prevent their deletion
    private final EegIndexChannel mIndexChannel;

	private final AnyChannelLengthChangedCallback lengthChangedCallback = new AnyChannelLengthChangedCallback() {
		@Override
		public void onDataLengthChanged(int dataLength) {
			dataLengthChanged.sendNotification(this, dataLength);
		}
    };

    public EmotionalStateChannel(EegIndexChannel indexChannel)
    {
        mIndexChannel = indexChannel;
        mAnyChannel = new AnyChannel(createEmotionStateChannel(mIndexChannel.channelPtr()), lengthChangedCallback);
    }

	public ChannelInfo info(){
        return mAnyChannel.info();
    }

    public int totalLength() {
        return mAnyChannel.totalLength();
    }

    public float samplingFrequency(){
        return mAnyChannel.samplingFrequency();
    }

    public long channelPtr(){
        return mAnyChannel.channelPtr();
    }

    public EmotionalState[] readData(int offset, int length){
		return readData(channelPtr(), offset, length);      
    }

    public int bufferSize() {
        return emotionalStateChannelGetBufferSize(channelPtr());
    }

    public static EmotionalStateName valueToName(EmotionalState value)
    {
        if (value.relaxation() >= 0.0 && value.relaxation() < 0.10 || value.concentration() >= 0.0 && value.concentration() < 0.10)
        {
            return EmotionalStateName.NormalActivation;
        }
        else
        {
            if (value.relaxation() >= 0.0)
            {
                return EmotionalStateName.Relaxation;
            }
            else
            {
                return EmotionalStateName.Concentration;
            }
        }
    }

    private static native long createEmotionStateChannel(long indexChannelPtr);
	private static native int emotionalStateChannelGetBufferSize(long channelPtr);
	private static native EmotionalState[] readData(long channelPtr, int offset, int length);
}
