package com.neuromd.neurosdk;

public final class EegIndexChannel extends BaseChannel {
    static {
        System.loadLibrary("android-neurosdk");
    }

    private final AnyChannel mAnyChannel;

    //store source channels reference to prevent their deletion
    private final EegChannel mT3;
    private final EegChannel mT4;
    private final EegChannel mO1;
    private final EegChannel mO2;

	private final AnyChannelLengthChangedCallback lengthChangedCallback = new AnyChannelLengthChangedCallback() {
        @Override
        public void onDataLengthChanged(int dataLength) {
            dataLengthChanged.sendNotification(this, dataLength);
        }
    };

    public EegIndexChannel(EegChannel t3, EegChannel t4, EegChannel o1, EegChannel o2)
    {
        mT3 = t3;
        mT4 = t4;
        mO1 = o1;
        mO2 = o2;
        mAnyChannel = new AnyChannel(create(mT3.channelPtr(), mT4.channelPtr(), mO1.channelPtr(), mO2.channelPtr()), lengthChangedCallback);
    }

	public ChannelInfo info(){
        return mAnyChannel.info();
    }

    public int totalLength() {
        return mAnyChannel.totalLength();
    }

    public int bufferSize() {
        return getBufferSize(channelPtr());
    }

    public float samplingFrequency(){
        return mAnyChannel.samplingFrequency();
    }

    public long channelPtr(){
        return mAnyChannel.channelPtr();
    }

    public EegIndexValues[] readData(int offset, int length)
    {
        return readData(channelPtr(), offset, length);
    }

    public void setDelay(double delay)
    {
        setDelay(channelPtr(), delay);
    }

    public void setWeights(double alpha, double beta, double delta, double theta)
    {
        setWeightCoefficients(channelPtr(), alpha, beta, delta, theta);
    }

    private static native long create(long t3, long t4, long o1, long o2);
    private static native EegIndexValues[] readData(long indexChannelPtr, int offset, int length);
    private static native int getBufferSize(long indexChannelPtr);
    private static native void setDelay(long indexChannelPtr, double delaySeconds);
    private static native void setWeightCoefficients(long indexChannelPtr, double alpha, double beta, double delta, double theta);
}
