package com.neuromd.neurosdk;

import android.util.Log;

public class EegChannel extends BaseDoubleChannel {
    static {
        System.loadLibrary("android-neurosdk");
    }

    private Device mDevice; //store device reference to prevent its deletion
    private final AnyChannel mAnyChannel;
    private final DoubleDataChannel mDataChannel;
	private BaseDoubleChannel mDoubleChannel;

    private final AnyChannelLengthChangedCallback lengthChangedCallback = new AnyChannelLengthChangedCallback() {
        @Override
        public void onDataLengthChanged(int dataLength) {
            dataLengthChanged.sendNotification(this, dataLength);
        }
    };

    public EegChannel(Device device)
    {
        mDevice = device;
        mAnyChannel = new AnyChannel(createEegDoubleChannel(device.devicePtr()), lengthChangedCallback);
        mDataChannel = new DoubleDataChannel(mAnyChannel);
    }

    public EegChannel(Device device, ChannelInfo info)
    {
        mDevice = device;
        mAnyChannel = new AnyChannel(createEegDoubleChannelInfo(device.devicePtr(), info), lengthChangedCallback);
        mDataChannel = new DoubleDataChannel(mAnyChannel);
    }

	public EegChannel(BaseDoubleChannel channel)
    {
		mDoubleChannel = channel;
        mAnyChannel = new AnyChannel(createEegDoubleChannelDoubleChannel(mDoubleChannel.channelPtr()), lengthChangedCallback);
        mDataChannel = new DoubleDataChannel(mAnyChannel);
    }

    public ChannelInfo info(){
        return mAnyChannel.info();
    }

    public int totalLength() {
        return mAnyChannel.totalLength();
    }

    public float samplingFrequency(){
        return mAnyChannel.samplingFrequency();
    }

    public long channelPtr(){
        return mAnyChannel.channelPtr();
    }

    public double[] readData(int offset, int length) {
        return mDataChannel.readData(offset, length);
    }

    private static native long createEegDoubleChannel(long devicePtr);
    private static native long createEegDoubleChannelInfo(long devicePtr, ChannelInfo info);
    private static native long createEegDoubleChannelDoubleChannel(long doubleChannelPtr);
}
