package com.neuromd.neurosdk;

public class EegArtifactChannel extends BaseChannel {
    static {
        System.loadLibrary("android-neurosdk");
    }

	private final AnyChannel mAnyChannel;

    //store source channels reference to prevent their deletion
    private final EegChannel mT3;
    private final EegChannel mT4;
    private final EegChannel mO1;
    private final EegChannel mO2;

	private final AnyChannelLengthChangedCallback lengthChangedCallback = new AnyChannelLengthChangedCallback() {
		@Override
		public void onDataLengthChanged(int dataLength) {
			dataLengthChanged.sendNotification(this, dataLength);
		}
    };

    public EegArtifactChannel(EegChannel t3, EegChannel t4, EegChannel o1, EegChannel o2)
    {
        mT3 = t3;
        mT4 = t4;
        mO1 = o1;
        mO2 = o2;
        mAnyChannel = new AnyChannel(createEegArtifactChannel(mT3.channelPtr(), mT4.channelPtr(), mO1.channelPtr(), mO2.channelPtr()), lengthChangedCallback);
    }
        
    public ChannelInfo info(){
        return mAnyChannel.info();
    }

    public int totalLength() {
        return mAnyChannel.totalLength();
    }

    public float samplingFrequency(){
        return mAnyChannel.samplingFrequency();
    }

    public long channelPtr(){
        return mAnyChannel.channelPtr();
    }

    public ArtifactZone[] readData(int offset, int length){
		return readData(channelPtr(), offset, length);      
    }

    public int bufferSize() {
        return eegArtifactChannelGetBufferSize(channelPtr());
    }

    private static native long createEegArtifactChannel(long t3, long t4, long o1, long o2);
	private static native int eegArtifactChannelGetBufferSize(long channelPtr);
	private static native ArtifactZone[] readData(long channelPtr, int offset, int length);
}
