package com.neuromd.neurosdk;


public class StressIndexChannel extends BaseDoubleChannel {
   static {
        System.loadLibrary("android-neurosdk");
    }

    private final RPeakChannel mChannel; //store channel reference to prevent its deletion
    private final AnyChannel mAnyChannel;
    private final DoubleDataChannel mDataChannel;
    private final AnyChannelLengthChangedCallback lengthChangedCallback = new AnyChannelLengthChangedCallback() {
        @Override
        public void onDataLengthChanged(int dataLength) {
            dataLengthChanged.sendNotification(this, dataLength);
        }
    };

    public StressIndexChannel(RPeakChannel rPeakChannel)
    {
        mChannel = rPeakChannel;
        mAnyChannel = new AnyChannel(createStressIndexChannel(mChannel.channelPtr()), lengthChangedCallback);
        mDataChannel = new DoubleDataChannel(mAnyChannel);
    }

    public ChannelInfo info(){
        return mAnyChannel.info();
    }

    public int totalLength() {
        return mAnyChannel.totalLength();
    }

    public float samplingFrequency(){
        return mAnyChannel.samplingFrequency();
    }

    public long channelPtr(){
        return mAnyChannel.channelPtr();
    }

    public double[] readData(int offset, int length) {
        return mDataChannel.readData(offset, length);
    }

    private static native long createStressIndexChannel(long channelPtr);
}