package com.neuromd.neurosdk;

public class RPeakChannel extends BaseChannel {
    static {
        System.loadLibrary("android-neurosdk");
    }

    private final BaseDoubleChannel mSignalDoubleChannel; //store channel reference to prevent its deletion
    private final ElectrodesStateChannel mElectrodeChannel; //store channel reference to prevent its deletion
    private final AnyChannel mAnyChannel;    
    private final IntDataChannel mDataChannel;

    public RPeakChannel(BaseDoubleChannel signalDoubleChannel)
    {
        mSignalDoubleChannel = signalDoubleChannel;
        mElectrodeChannel = null;
        mAnyChannel = new AnyChannel(createRPeakChannel(mSignalDoubleChannel.channelPtr()), new AnyChannelLengthChangedCallback() {
            @Override
            public void onDataLengthChanged(int dataLength) {
                dataLengthChanged.sendNotification(this, dataLength);
            }
        });        
        mDataChannel = new IntDataChannel(mAnyChannel);
    }

    public RPeakChannel(BaseDoubleChannel signalDoubleChannel, ElectrodesStateChannel electrodeChannel)
    {
        mSignalDoubleChannel = signalDoubleChannel;
        mElectrodeChannel = electrodeChannel;
        mAnyChannel = new AnyChannel(createRPeakChannel_ElectrodeState(mSignalDoubleChannel.channelPtr(), mElectrodeChannel.channelPtr()), new AnyChannelLengthChangedCallback() {
            @Override
            public void onDataLengthChanged(int dataLength) {
                dataLengthChanged.sendNotification(this, dataLength);
            }
        });        
        mDataChannel = new IntDataChannel(mAnyChannel);
    }

    public ChannelInfo info(){
        return mAnyChannel.info();
    }

    public int totalLength() {
        return mAnyChannel.totalLength();
    }

    public float samplingFrequency(){
        return mAnyChannel.samplingFrequency();
    }

    public long channelPtr(){
        return mAnyChannel.channelPtr();
    }

    public int[] readData(int offset, int length) {
        return mDataChannel.readData(offset, length);
    }

    private static native long createRPeakChannel(long channelPtr);
    private static native long createRPeakChannel_ElectrodeState(long channelPtr, long electrodePtr);
}