package com.neuromd.neurosdk;

public class HeartRateChannel extends BaseChannel
{
    static {
        System.loadLibrary("android-neurosdk");
    }

    private final RPeakChannel mChannel; //store channel reference to prevent its deletion
    private final AnyChannel mAnyChannel;
    private final IntDataChannel mDataChannel;
    private final AnyChannelLengthChangedCallback lengthChangedCallback = new AnyChannelLengthChangedCallback() {
        @Override
        public void onDataLengthChanged(int dataLength) {
            dataLengthChanged.sendNotification(this, dataLength);
        }
    };

    public HeartRateChannel(RPeakChannel channel)
    {
        mChannel = channel;
        mAnyChannel = new AnyChannel(createHeartRateChannel(mChannel.channelPtr()), lengthChangedCallback);
        mDataChannel = new IntDataChannel(mAnyChannel);
    }

    public ChannelInfo info(){
        return mAnyChannel.info();
    }

    public int totalLength() {
        return mAnyChannel.totalLength();
    }

    public float samplingFrequency(){
        return mAnyChannel.samplingFrequency();
    }

    public long channelPtr(){
        return mAnyChannel.channelPtr();
    }

    public int[] readData(int offset, int length) {
        return mDataChannel.readData(offset, length);
    }

    private static native long createHeartRateChannel(long devicePtr);
}