package com.neuromd.neurosdk;

public class EcgChannel extends BaseDoubleChannel {
    static {
        System.loadLibrary("android-neurosdk");
    }

    private final Device mDevice; //store device reference to prevent its deletion
    private final AnyChannel mAnyChannel;
    private final DoubleDataChannel mDataChannel;
    private final AnyChannelLengthChangedCallback lengthChangedCallback = new AnyChannelLengthChangedCallback() {
        @Override
        public void onDataLengthChanged(int dataLength) {
            dataLengthChanged.sendNotification(this, dataLength);
        }
    };

    public EcgChannel(Device device)
    {
        mDevice = device;
        mAnyChannel = new AnyChannel(createEcgDoubleChannel(device.devicePtr()), lengthChangedCallback);
        mDataChannel = new DoubleDataChannel(mAnyChannel);
    }

    public EcgChannel(Device device, ChannelInfo info)
    {
        mDevice = device;
        mAnyChannel = new AnyChannel(createEcgDoubleChannelInfo(device.devicePtr(), info), lengthChangedCallback);
        mDataChannel = new DoubleDataChannel(mAnyChannel);
    }

    public ChannelInfo info(){
        return mAnyChannel.info();
    }

    public int totalLength() {
        return mAnyChannel.totalLength();
    }

    public int bufferSize() {
        return ecgDoubleChannelGetBufferSize(channelPtr());
    }

    public float samplingFrequency(){
        return mAnyChannel.samplingFrequency();
    }

    public long channelPtr(){
        return mAnyChannel.channelPtr();
    }

    public double[] readData(int offset, int length) {
        return mDataChannel.readData(offset, length);
    }

    private static native long createEcgDoubleChannel(long devicePtr);
    private static native long createEcgDoubleChannelInfo(long devicePtr, ChannelInfo info);
    private static native int ecgDoubleChannelGetBufferSize(long signalChannelPtr);
}
