package com.neuromd.neurosdk;

public class SpectrumPowerChannel extends BaseDoubleChannel {
    static {
        System.loadLibrary("android-neurosdk");
    }

	private final SpectrumChannel[] mChannels;
    private final AnyChannel mAnyChannel;
    private final DoubleDataChannel mDataChannel;
    private final AnyChannelLengthChangedCallback lengthChangedCallback = new AnyChannelLengthChangedCallback() {
        @Override
        public void onDataLengthChanged(int dataLength) {
            dataLengthChanged.sendNotification(this, dataLength);
        }
    };

	public SpectrumPowerChannel(SpectrumChannel[] channels, float lowFrequency, float highFrequency, String name, double windowDuration, double overlapCoeff){
        mChannels = channels;
        mAnyChannel = new AnyChannel(createSpectrumPowerDoubleChannel(mChannels, lowFrequency, highFrequency, name, windowDuration, overlapCoeff), lengthChangedCallback);
        mDataChannel = new DoubleDataChannel(mAnyChannel);
    }

	public SpectrumPowerChannel(SpectrumChannel[] channels, float lowFrequency, float highFrequency, String name, double windowDuration){
        mChannels = channels;
        mAnyChannel = new AnyChannel(createSpectrumPowerDoubleChannel(mChannels, lowFrequency, highFrequency, name, windowDuration, 0.95), lengthChangedCallback);
        mDataChannel = new DoubleDataChannel(mAnyChannel);
    }

	public SpectrumPowerChannel(SpectrumChannel[] channels, float lowFrequency, float highFrequency, String name){
        mChannels = channels;
        mAnyChannel = new AnyChannel(createSpectrumPowerDoubleChannel(mChannels, lowFrequency, highFrequency, name, 8.0, 0.95), lengthChangedCallback);
        mDataChannel = new DoubleDataChannel(mAnyChannel);
    }

    public ChannelInfo info(){
        return mAnyChannel.info();
    }

    public int totalLength() {
        return mAnyChannel.totalLength();
    }

    public float samplingFrequency(){
        return mAnyChannel.samplingFrequency();
    }

    public long channelPtr(){
        return mAnyChannel.channelPtr();
    }

    public double[] readData(int offset, int length) {
        return mDataChannel.readData(offset, length);
    }

    public void setWindowDuration(double duration){
        setWindowDuration(channelPtr(), duration);
    }

    public void setOverlappingCoefficient(double coefficient){
        setOverlappingCoefficient(channelPtr(), coefficient);
    }

    public static double spectrumPower(float lowFrequency, float highFrequency, double[] spectrum, float frequencyStep){
        return spectrumPowerNormalized(lowFrequency, highFrequency, spectrum, frequencyStep);
    }

    private static native long createSpectrumPowerDoubleChannel(SpectrumChannel[] channels, float lowFreq, float highFreq, String name, double windowDuration, double overlappingCoeff);
    private static native void setOverlappingCoefficient(long channel, double overlap);
    private static native void setWindowDuration(long channel, double duration);
    private static native double spectrumPowerNormalized(float lowFrequency, float highFrequency, double[] spectrum, float frequencyStep);
}