package com.neuromd.neurosdk;

public class SpectrumChannel extends BaseDoubleChannel {
    static {
        System.loadLibrary("android-neurosdk");
    }

    private final BaseDoubleChannel mChannel; //store device reference to prevent its deletion
    private final AnyChannel mAnyChannel;
    private final AnyChannelLengthChangedCallback lengthChangedCallback = new AnyChannelLengthChangedCallback() {
        @Override
        public void onDataLengthChanged(int dataLength) {
            dataLengthChanged.sendNotification(this, dataLength);
        }
    };

    public SpectrumChannel(BaseDoubleChannel channel) {
        mChannel = channel;
        mAnyChannel = new AnyChannel(createSpectrumDoubleChannel(mChannel.channelPtr()), lengthChangedCallback);
    }

    public ChannelInfo info(){
        return mAnyChannel.info();
    }

    public int totalLength() {
        return mAnyChannel.totalLength();
    }

    public float samplingFrequency(){
        return mAnyChannel.samplingFrequency();
    }

    public long channelPtr(){
        return mAnyChannel.channelPtr();
    }

    public double[] readData(int offset, int length) {
        return readData(channelPtr(), offset, length);
    }

    public double hzPerSpectrumSample() {
        return SpectrumDoubleChannelGetHzPerSpectrumSample(mAnyChannel.channelPtr());
    }

    public int spectrumLength() {
        return SpectrumDoubleChannelGetSpectrumLength(mAnyChannel.channelPtr());
    }

    private static native long createSpectrumDoubleChannel(long channelPtr);
    private static native double SpectrumDoubleChannelGetHzPerSpectrumSample(long spectrumChannelPtr);
    private static native int SpectrumDoubleChannelGetSpectrumLength(long spectrumChannelPtr);
    public static native double[] readData(long doubleChannelPtr, int offset, int length);
}