package com.neuromd.neurosdk;

public class RespirationChannel extends BaseDoubleChannel {
    static {
        System.loadLibrary("android-neurosdk");
    }

    private final Device mDevice; //store device reference to prevent its deletion
    private final AnyChannel mAnyChannel;
    private final DoubleDataChannel mDataChannel;

    public RespirationChannel(Device device) {
        mDevice = device;
        mAnyChannel = new AnyChannel(createRespirationDoubleChannel(device.devicePtr()), new AnyChannelLengthChangedCallback() {
            @Override
            public void onDataLengthChanged(int dataLength) {
                dataLengthChanged.sendNotification(this, dataLength);
            }
        });
        mDataChannel = new DoubleDataChannel(mAnyChannel);
    }

    public ChannelInfo info(){
        return mAnyChannel.info();
    }

    public int totalLength() {
        return mAnyChannel.totalLength();
    }

    public long bufferSize() {
        return RespirationDoubleChannelGetBufferSize(channelPtr());
    }

    public float samplingFrequency(){
        return mAnyChannel.samplingFrequency();
    }

    public long channelPtr(){
        return mAnyChannel.channelPtr();
    }

    public double[] readData(int offset, int length) {
        return mDataChannel.readData(offset, length);
    }

    private static native long createRespirationDoubleChannel(long devicePtr);
    private static native int RespirationDoubleChannelGetBufferSize(long respChannelPtr);
}
