package com.neuromd.neurosdk;

import java.util.List;

/**
 * Built-in channel containing signal samples of one physical channel of device
 */
public class EmulationChannel extends BaseDoubleChannel {
    static {
        System.loadLibrary("android-neurosdk");
    }

    private final AnyChannel mAnyChannel;
    private final DoubleDataChannel mDataChannel;
    private final AnyChannelLengthChangedCallback lengthChangedCallback = new AnyChannelLengthChangedCallback() {
        @Override
        public void onDataLengthChanged(int dataLength) {
            dataLengthChanged.sendNotification(this, dataLength);
        }
    };

    public EmulationChannel(List<EmulationSine> components, float samplingFrequency, int initialLength)
    {
        mAnyChannel = new AnyChannel(createEmulationChannel(components, samplingFrequency, initialLength), lengthChangedCallback);
        mDataChannel = new DoubleDataChannel(mAnyChannel);
    }

    public ChannelInfo info(){
        return mAnyChannel.info();
    }

    public int totalLength() {
        return mAnyChannel.totalLength();
    }

    public float samplingFrequency(){
        return mAnyChannel.samplingFrequency();
    }

    public long channelPtr(){
        return mAnyChannel.channelPtr();
    }

    public double[] readData(int offset, int length) {
        return mDataChannel.readData(offset, length);
    }

    public void startTimer(){
        startTimer(channelPtr());
    }

    public void stopTimer(){
        stopTimer(channelPtr());
    }

    public void reset(){
        reset(channelPtr());
    }

   private static native long createEmulationChannel(List<EmulationSine> components, float samplingFrequency, int initialLength);
   private static native void startTimer(long emulationChannelPtr);
   private static native void stopTimer(long emulationChannelPtr);
   private static native void reset(long emulationChannelPtr);
}
