package com.neuromd.neurosdk;

public class ElectrodesStateChannel extends BaseChannel {
    static {
        System.loadLibrary("android-neurosdk");
    }

    private final Device mDevice; //store device reference to prevent its deletion
    private final AnyChannel mAnyChannel;
    private final AnyChannelLengthChangedCallback lengthChangedCallback = new AnyChannelLengthChangedCallback() {
        @Override
        public void onDataLengthChanged(int dataLength) {
            dataLengthChanged.sendNotification(this, dataLength);
        }
    };

    public ElectrodesStateChannel(Device device)
    {
        mDevice = device;
        mAnyChannel = new AnyChannel(createElectrodeStateChannel(device.devicePtr()), lengthChangedCallback);
    }

    public ChannelInfo info(){
        return mAnyChannel.info();
    }

    public int totalLength() {
        return mAnyChannel.totalLength();
    }

    public int bufferSize() {
        return ElectrodeStateChannelGetBufferSize(channelPtr());
    }

    public float samplingFrequency(){
        return mAnyChannel.samplingFrequency();
    }

    public long channelPtr(){
        return mAnyChannel.channelPtr();
    }

    public ElectrodeState[] readData(int offset, int length) {
        return readData(mAnyChannel.channelPtr(), offset, length);
    }

    private static native long createElectrodeStateChannel(long devicePtr);
    private static native int ElectrodeStateChannelGetBufferSize(long channelPtr);
    private static native ElectrodeState[] readData(long channelPtr, int offset, int length);
}
