package com.neuromd.neurosdk;

public class BipolarDoubleChannel extends BaseDoubleChannel {
    static {
        System.loadLibrary("android-neurosdk");
    }

	private final BaseDoubleChannel mFirstChannel; //store channel reference to prevent its deletion
	private final BaseDoubleChannel mSecondtChannel; //store channel reference to prevent its deletion
    private final AnyChannel mAnyChannel;
    private final DoubleDataChannel mDataChannel;
	private final AnyChannelLengthChangedCallback lengthChangedCallback = new AnyChannelLengthChangedCallback() {
        @Override
        public void onDataLengthChanged(int dataLength) {
            dataLengthChanged.sendNotification(this, dataLength);
        }
    };

	public BipolarDoubleChannel(BaseDoubleChannel first, BaseDoubleChannel second)
    {
        mFirstChannel = first;
        mSecondtChannel = second;
        mAnyChannel = new AnyChannel(createBipolarDoubleChannel(first.channelPtr(), second.channelPtr()), lengthChangedCallback);
        mDataChannel = new DoubleDataChannel(mAnyChannel);
    }

	public ChannelInfo info(){
        return mAnyChannel.info();
    }

    public int totalLength() {
        return mAnyChannel.totalLength();
    }

    public float samplingFrequency(){
        return mAnyChannel.samplingFrequency();
    }

    public long channelPtr(){
        return mAnyChannel.channelPtr();
    }

    public double[] readData(int offset, int length) {
        return mDataChannel.readData(offset, length);
    }

	private static native long createBipolarDoubleChannel(long firstPtr, long secondPtr);
}
        