package com.neuromd.neurosdk;

/**
 * Built-in channel containing battery charge data
 */
public class BatteryChannel extends BaseChannel {
    static {
        System.loadLibrary("android-neurosdk");
    }

    private final Device mDevice; //store device reference to prevent its deletion
    private final AnyChannel mAnyChannel;
    private final IntDataChannel mDataChannel;
    private final AnyChannelLengthChangedCallback lengthChangedCallback = new AnyChannelLengthChangedCallback() {
        @Override
        public void onDataLengthChanged(int dataLength) {
            dataLengthChanged.sendNotification(this, dataLength);
        }
    };

    public BatteryChannel(Device device)
    {
        mDevice = device;
        mAnyChannel = new AnyChannel(createBatteryIntChannel(device.devicePtr()), lengthChangedCallback);
        mDataChannel = new IntDataChannel(mAnyChannel);
    }

    public ChannelInfo info(){
        return mAnyChannel.info();
    }

    public int totalLength() {
        return mAnyChannel.totalLength();
    }

    public int bufferSize() {
        return BatteryIntChannelGetBufferSize(channelPtr());
    }

    public float samplingFrequency(){
        return mAnyChannel.samplingFrequency();
    }

    public long channelPtr(){
        return mAnyChannel.channelPtr();
    }

    public int[] readData(int offset, int length) {
        return mDataChannel.readData(offset, length);
    }

    private static native long createBatteryIntChannel(long devicePtr);
    private static native int BatteryIntChannelGetBufferSize(long batteryChannelPtr);
}
