/*
 * Decompiled with CFR 0.152.
 */
package com.neuromd.bleconnection.scanner;

import android.annotation.TargetApi;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanResult;
import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import com.neuromd.bleconnection.exceptions.BluetoothAdapterException;
import com.neuromd.bleconnection.exceptions.BluetoothPermissionException;
import com.neuromd.bleconnection.scanner.BleDeviceScanner;

@TargetApi(value=21)
public class BleDeviceScanner21Api
extends BleDeviceScanner {
    private ScanCallback mScanCallback;

    public BleDeviceScanner21Api() {
        Log.v((String)"BleDeviceScanner21Api", (String)"Created scanner for API 21 and higher");
        this.mScanCallback = new ScanCallback(){

            public void onScanResult(int callbackType, ScanResult result) {
                BleDeviceScanner21Api.this.onDeviceFound(result.getDevice());
            }
        };
    }

    @Override
    public void startScan(Context context) throws BluetoothPermissionException, BluetoothAdapterException {
        this.initAdapter(context);
        if (ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
            throw new BluetoothPermissionException("Location permission does not allowed");
        }
        this.mBluetoothAdapter.getBluetoothLeScanner().startScan(this.mScanCallback);
    }

    @Override
    public void stopScan() {
        if (this.mBluetoothAdapter == null) {
            return;
        }
        BluetoothLeScanner scanner = this.mBluetoothAdapter.getBluetoothLeScanner();
        if (scanner == null) {
            return;
        }
        this.mBluetoothAdapter.getBluetoothLeScanner().stopScan(this.mScanCallback);
    }
}

