/*
 * Decompiled with CFR 0.152.
 */
package com.neuromd.bleconnection.device;

import android.util.Log;
import java.util.UUID;

public class DeviceGattInfo {
    private long mNativeObjectPtr;

    public DeviceGattInfo(long nativeObjectPtr) {
        this.mNativeObjectPtr = nativeObjectPtr;
    }

    protected void finalize() throws Throwable {
        this.deleteGattInfo(this.mNativeObjectPtr);
        super.finalize();
    }

    public UUID deviceServiceUUID() {
        return this.uuidFromString(this.getDeviceServiceUUID(this.mNativeObjectPtr));
    }

    public UUID rxCharacteristicUUID() {
        return this.uuidFromString(this.getRxCharacteristicUUID(this.mNativeObjectPtr));
    }

    public UUID txCharacteristicUUID() {
        return this.uuidFromString(this.getTxCharacteristicUUID(this.mNativeObjectPtr));
    }

    public UUID statusCharacteristicUUID() {
        return this.uuidFromString(this.getStatusCharacteristicUUID(this.mNativeObjectPtr));
    }

    public UUID genericAccessServiceUUID() {
        return this.uuidFromString(this.getGenericAccessServiceUUID(this.mNativeObjectPtr));
    }

    public UUID CCCD() {
        return this.uuidFromString(this.getCCCD(this.mNativeObjectPtr));
    }

    private UUID uuidFromString(String uuidString) {
        UUID uuid;
        if (uuidString == null || uuidString.isEmpty()) {
            return null;
        }
        try {
            uuid = UUID.fromString(uuidString);
        }
        catch (IllegalArgumentException exc) {
            Log.e((String)"DeviceGattInfoWrapper", (String)("Unable to parse UUID: " + exc.getMessage()));
            return null;
        }
        return uuid;
    }

    private native void deleteGattInfo(long var1);

    private native String getDeviceServiceUUID(long var1);

    private native String getRxCharacteristicUUID(long var1);

    private native String getTxCharacteristicUUID(long var1);

    private native String getStatusCharacteristicUUID(long var1);

    private native String getGenericAccessServiceUUID(long var1);

    private native String getCCCD(long var1);
}

