/*
 * Decompiled with CFR 0.152.
 */
package com.neuromd.bleconnection.scanner;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.util.Log;
import com.neuromd.bleconnection.device.DeviceFilter;
import com.neuromd.bleconnection.device.DeviceFoundCallback;
import com.neuromd.bleconnection.exceptions.BluetoothAdapterException;
import com.neuromd.bleconnection.exceptions.BluetoothPermissionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BleDeviceScanner {
    private final List<BluetoothDevice> mDevices = Collections.synchronizedList(new ArrayList());
    private DeviceFilter mFilter;
    private DeviceFoundCallback mDeviceFoundCallback;
    protected BluetoothAdapter mBluetoothAdapter;

    public void setFilter(DeviceFilter filter) {
        this.mFilter = filter;
    }

    public List<BluetoothDevice> getDevices() {
        return this.mDevices;
    }

    public int getDeviceCount() {
        return this.mDevices.size();
    }

    public BluetoothDevice getDeviceByAddress(Context context, String address) throws BluetoothAdapterException {
        this.initAdapter(context);
        if (!BluetoothAdapter.checkBluetoothAddress((String)address)) {
            return null;
        }
        return this.mBluetoothAdapter.getRemoteDevice(address);
    }

    public abstract void startScan(Context var1) throws BluetoothPermissionException, BluetoothAdapterException;

    public abstract void stopScan();

    public void reset() {
        Log.v((String)"BleDeviceScanner", (String)"reset");
        this.mDevices.clear();
    }

    public void subscribeDeviceFound(DeviceFoundCallback callback) {
        this.mDeviceFoundCallback = callback;
    }

    protected void initAdapter(Context context) throws BluetoothAdapterException {
        Log.v((String)"Scanner", (String)"Init adapter");
        if (this.mBluetoothAdapter != null && this.mBluetoothAdapter.isEnabled()) {
            return;
        }
        if (this.mBluetoothAdapter == null) {
            BluetoothManager bluetoothManager = (BluetoothManager)context.getSystemService("bluetooth");
            this.mBluetoothAdapter = bluetoothManager.getAdapter();
        }
        if (this.mBluetoothAdapter == null || !this.mBluetoothAdapter.isEnabled()) {
            throw new BluetoothAdapterException("Bluetooth adapter initialization failure");
        }
    }

    protected void onDeviceFound(final BluetoothDevice device) {
        if (device == null || device.getName() == null) {
            return;
        }
        Log.v((String)"Scanner", (String)String.format("Found device: %s", device.getName()));
        if (this.mFilter != null && !this.mFilter.filter(device.getName())) {
            return;
        }
        if (this.deviceAlreadyFound(device)) {
            return;
        }
        this.mDevices.add(device);
        if (this.mDeviceFoundCallback != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    BleDeviceScanner.this.mDeviceFoundCallback.onDeviceFound(device);
                }
            }).start();
        }
    }

    private boolean deviceAlreadyFound(BluetoothDevice newDevice) {
        if (this.mDevices.isEmpty()) {
            Log.v((String)"BleDeviceList", (String)"List is empty");
            return false;
        }
        for (BluetoothDevice device : this.mDevices) {
            if (!device.getName().equals(newDevice.getName()) || !device.getAddress().equals(newDevice.getAddress())) continue;
            return true;
        }
        return false;
    }

    protected void releaseDevice(String name, String address) {
        if (this.mDevices.isEmpty()) {
            Log.v((String)"BleDeviceList", (String)"List is empty");
            return;
        }
        int devIndex = -1;
        for (BluetoothDevice device : this.mDevices) {
            if (!device.getName().equals(name) || !device.getAddress().equals(address)) continue;
            devIndex = this.mDevices.indexOf(device);
            break;
        }
        if (devIndex >= 0) {
            this.mDevices.remove(devIndex);
        }
    }
}

