/*
 * Decompiled with CFR 0.152.
 */
package com.neuromd.bleconnection.device;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.content.Context;
import android.os.ConditionVariable;
import android.util.Log;
import com.neuromd.bleconnection.device.BleDeviceCallback;
import com.neuromd.bleconnection.device.BleDeviceState;
import com.neuromd.bleconnection.device.BluetoothDeviceError;
import com.neuromd.bleconnection.device.DeviceGattInfo;
import java.lang.reflect.Method;
import java.util.concurrent.locks.ReentrantLock;

public class BleDevice {
    private static final int MAX_WRITE_TX_CHARACTERISTIC_ATTEMPTS = 3;
    private static final int WRITE_TX_CHARACTERISTIC_RETRY_DELAY_MS = 300;
    private final String mName;
    private final String mAddress;
    private ConditionVariable mWriteDescriptorCondition = new ConditionVariable(true);
    private ReentrantLock mWriteDescriptorLock = new ReentrantLock();
    private BluetoothGattCallback mBleGattCallback = new BluetoothGattCallback(){

        public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
            block8: {
                block7: {
                    if (status != 0 && status != 8) break block7;
                    switch (newState) {
                        case 1: {
                            Log.d((String)"JavaBleDevice", (String)"On connecting");
                            break;
                        }
                        case 2: {
                            Log.d((String)"JavaBleDevice", (String)"On connected");
                            if (!gatt.discoverServices()) {
                                new Thread(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (BleDevice.this.mDeviceCallback != null) {
                                            BleDevice.this.mDeviceCallback.onBluetoothDeviceError(BluetoothDeviceError.SERVICE_NOT_FOUND);
                                        }
                                    }
                                }).start();
                                break;
                            }
                            break block8;
                        }
                        case 3: {
                            Log.d((String)"JavaBleDevice", (String)"On disconnecting");
                            break;
                        }
                        case 0: {
                            Log.d((String)"JavaBleDevice", (String)"On disconnected");
                            BleDevice.this.mConnectionState = BleDeviceState.DISCONNECTED;
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    if (BleDevice.this.mDeviceCallback != null) {
                                        BleDevice.this.mDeviceCallback.onDisconnected();
                                    }
                                }
                            }).start();
                            break;
                        }
                        default: {
                            Log.e((String)"JavaBleDevice", (String)"Unknown connection state");
                            BleDevice.this.mConnectionState = BleDeviceState.ERROR;
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    if (BleDevice.this.mDeviceCallback != null) {
                                        BleDevice.this.mDeviceCallback.onBluetoothDeviceError(BluetoothDeviceError.GENERAL_CONNECTION_ERROR);
                                    }
                                }
                            }).start();
                            break;
                        }
                    }
                    break block8;
                }
                Log.e((String)"JavaBleDevice", (String)String.format("Failed change connection state. Error code: %d", status));
                BleDevice.this.mConnectionState = BleDeviceState.ERROR;
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (BleDevice.this.mDeviceCallback != null) {
                            BleDevice.this.mDeviceCallback.onBluetoothDeviceError(BluetoothDeviceError.GENERAL_CONNECTION_ERROR);
                        }
                    }
                }).start();
            }
        }

        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
            Log.v((String)"JavaBleDevice", (String)"On services discovered");
            if (status != 0) {
                BleDevice.this.mConnectionState = BleDeviceState.ERROR;
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (BleDevice.this.mDeviceCallback != null) {
                            BleDevice.this.mDeviceCallback.onBluetoothDeviceError(BluetoothDeviceError.SERVICE_NOT_FOUND);
                        }
                    }
                }).start();
                return;
            }
            final BluetoothGattService deviceService = gatt.getService(BleDevice.this.mGattInfo.deviceServiceUUID());
            if (deviceService == null) {
                BleDevice.this.mConnectionState = BleDeviceState.ERROR;
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (BleDevice.this.mDeviceCallback != null) {
                            BleDevice.this.mDeviceCallback.onBluetoothDeviceError(BluetoothDeviceError.SERVICE_NOT_FOUND);
                        }
                    }
                }).start();
                return;
            }
            BluetoothGattCharacteristic txCharacteristic = deviceService.getCharacteristic(BleDevice.this.mGattInfo.txCharacteristicUUID());
            if (txCharacteristic == null) {
                Log.e((String)"JavaBleDevice", (String)"Transmit characteristic not found");
                BleDevice.this.mConnectionState = BleDeviceState.ERROR;
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (BleDevice.this.mDeviceCallback != null) {
                            BleDevice.this.mDeviceCallback.onBluetoothDeviceError(BluetoothDeviceError.TX_NOT_FOUND);
                        }
                    }
                }).start();
                return;
            }
            BleDevice.this.mTxCharacteristic = txCharacteristic;
            Log.v((String)"JavaBleDevice", (String)"On transmit ready");
            new Thread(new Runnable(){

                /*
                 * Enabled aggressive block sorting
                 */
                @Override
                public void run() {
                    block8: {
                        BluetoothGattCharacteristic rxCharacteristic = deviceService.getCharacteristic(BleDevice.this.mGattInfo.rxCharacteristicUUID());
                        if (rxCharacteristic == null) {
                            Log.e((String)"JavaBleDevice", (String)"Receive characteristic not found");
                            BleDevice.this.mConnectionState = BleDeviceState.ERROR;
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    if (BleDevice.this.mDeviceCallback != null) {
                                        BleDevice.this.mDeviceCallback.onBluetoothDeviceError(BluetoothDeviceError.RX_NOT_FOUND);
                                    }
                                }
                            }).start();
                            return;
                        }
                        if (!BleDevice.this.setCharacteristicNotification(rxCharacteristic, true)) {
                            Log.e((String)"JavaBleDevice", (String)"Failed to enable notifications for receive characteristic");
                            BleDevice.this.mConnectionState = BleDeviceState.ERROR;
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    if (BleDevice.this.mDeviceCallback != null) {
                                        BleDevice.this.mDeviceCallback.onBluetoothDeviceError(BluetoothDeviceError.STATUS_NOT_FOUND);
                                    }
                                }
                            }).start();
                            return;
                        }
                        Log.v((String)"JavaBleDevice", (String)"On receive ready");
                        if (BleDevice.this.mGattInfo.statusCharacteristicUUID() != null) {
                            BluetoothGattCharacteristic statusCharacteristic = deviceService.getCharacteristic(BleDevice.this.mGattInfo.statusCharacteristicUUID());
                            if (statusCharacteristic != null) {
                                if (BleDevice.this.setCharacteristicNotification(statusCharacteristic, true)) {
                                    Log.v((String)"JavaBleDevice", (String)"On status ready");
                                    break block8;
                                } else {
                                    Log.e((String)"JavaBleDevice", (String)"Failed to enable notifications for status characteristic");
                                    BleDevice.this.mConnectionState = BleDeviceState.ERROR;
                                    if (BleDevice.this.mDeviceCallback != null) {
                                        BleDevice.this.mDeviceCallback.onBluetoothDeviceError(BluetoothDeviceError.STATUS_NOT_FOUND);
                                    }
                                    return;
                                }
                            }
                            Log.e((String)"JavaBleDevice", (String)"Status characteristic not found");
                            BleDevice.this.mConnectionState = BleDeviceState.ERROR;
                            if (BleDevice.this.mDeviceCallback != null) {
                                BleDevice.this.mDeviceCallback.onBluetoothDeviceError(BluetoothDeviceError.STATUS_NOT_FOUND);
                            }
                            return;
                        }
                    }
                    BleDevice.this.mConnectionState = BleDeviceState.CONNECTED;
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            if (BleDevice.this.mDeviceCallback != null) {
                                BleDevice.this.mDeviceCallback.onConnected();
                            }
                        }
                    }).start();
                }
            }).start();
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            Log.v((String)"JavaBleDevice", (String)String.format("Characteristic onWrite status: %d", status));
            if (status != 0) {
                Log.e((String)"JavaBleDevice", (String)"Characteristic write error");
                BleDevice.this.mConnectionState = BleDeviceState.ERROR;
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (BleDevice.this.mDeviceCallback != null) {
                            BleDevice.this.mDeviceCallback.onBluetoothDeviceError(BluetoothDeviceError.GENERAL_CONNECTION_ERROR);
                        }
                    }
                }).start();
            }
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            if (characteristic.getUuid().equals(BleDevice.this.mGattInfo.rxCharacteristicUUID())) {
                BleDevice.this.onReceiveCharacteristicChanged(characteristic);
            } else if (characteristic.getUuid().equals(BleDevice.this.mGattInfo.statusCharacteristicUUID())) {
                BleDevice.this.onStatusCharacteristicChanged(characteristic);
            }
        }

        public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            Log.v((String)"JavaBleDevice", (String)String.format("Descriptor onWrite status: %d", status));
            if (status != 0) {
                BleDevice.this.mConnectionState = BleDeviceState.ERROR;
                Log.e((String)"JavaBleDevice", (String)"Descriptor write response error");
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (BleDevice.this.mDeviceCallback != null) {
                            BleDevice.this.mDeviceCallback.onBluetoothDeviceError(BluetoothDeviceError.GENERAL_CONNECTION_ERROR);
                        }
                    }
                }).start();
                return;
            }
            Log.v((String)"JavaBleDevice", (String)"Descriptor been written successfully");
            BleDevice.this.mWriteDescriptorCondition.open();
        }
    };
    private DeviceGattInfo mGattInfo;
    private final BluetoothDevice mBleDevice;
    private BluetoothGatt mDeviceGatt;
    private BluetoothGattCharacteristic mTxCharacteristic;
    private BleDeviceCallback mDeviceCallback;
    private BleDeviceState mConnectionState = BleDeviceState.DISCONNECTED;

    private void onReceiveCharacteristicChanged(BluetoothGattCharacteristic rxCharacteristic) {
        byte[] data = rxCharacteristic.getValue();
        if (this.mDeviceCallback != null) {
            this.mDeviceCallback.onDataReceived(data);
        }
    }

    private void onStatusCharacteristicChanged(BluetoothGattCharacteristic statusCharacteristic) {
        byte[] statusData = statusCharacteristic.getValue();
        Log.v((String)"JavaBleDevice", (String)"On status characteristic changed");
        if (this.mDeviceCallback != null) {
            this.mDeviceCallback.onStatusReceived(statusData);
        }
    }

    private boolean setCharacteristicNotification(BluetoothGattCharacteristic characteristic, boolean enabled) {
        if (characteristic == null) {
            Log.e((String)"Connectivity", (String)"Gatt characteristic is null");
            return false;
        }
        if (this.mDeviceGatt == null) {
            Log.e((String)"JavaBleDevice", (String)"Cannot set notifications. Device GATT is null");
            return false;
        }
        this.mWriteDescriptorLock.lock();
        boolean chSet = this.mDeviceGatt.setCharacteristicNotification(characteristic, enabled);
        BluetoothGattDescriptor descriptor = characteristic.getDescriptor(this.mGattInfo.CCCD());
        if (descriptor == null) {
            return false;
        }
        descriptor.setValue(enabled ? BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE : BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE);
        this.mWriteDescriptorCondition.close();
        boolean descWritten = this.mDeviceGatt.writeDescriptor(descriptor);
        boolean result = this.mWriteDescriptorCondition.block(1000L) && chSet && descWritten;
        this.mWriteDescriptorLock.unlock();
        Log.v((String)"BleDevice", (String)String.format("Characteristic descriptor %s", result ? "been written successfully" : "not written"));
        return result;
    }

    public BleDevice(BluetoothDevice sourceDevice, DeviceGattInfo gattInfo) {
        Log.v((String)"JavaBleDevice", (String)"Constructor");
        this.mBleDevice = sourceDevice;
        this.mName = this.mBleDevice.getName();
        this.mAddress = this.mBleDevice.getAddress();
        this.mGattInfo = gattInfo;
    }

    public void finalize() throws Throwable {
        Log.d((String)"JavaBleDevice", (String)"Finalizing");
        this.close();
        super.finalize();
    }

    public String name() {
        return this.mName;
    }

    public String address() {
        return this.mAddress;
    }

    public BleDeviceState state() {
        return this.mConnectionState;
    }

    private boolean refreshDeviceCache(BluetoothGatt gatt) {
        try {
            Method localMethod = gatt.getClass().getMethod("refresh", new Class[0]);
            if (localMethod != null) {
                return (Boolean)localMethod.invoke((Object)gatt, new Object[0]);
            }
        }
        catch (Exception localException) {
            Log.e((String)"JavaBleDevice", (String)"An exception occurred while refreshing device");
        }
        return false;
    }

    public void connect(final Context context) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Log.v((String)"JavaBleDevice", (String)"Connecting to device");
                if (BleDevice.this.mDeviceGatt == null) {
                    if (BleDevice.this.mBleDevice == null) {
                        BleDevice.this.mConnectionState = BleDeviceState.ERROR;
                        return;
                    }
                    BleDevice.this.mDeviceGatt = BleDevice.this.mBleDevice.connectGatt(context, false, BleDevice.this.mBleGattCallback);
                    BleDevice.this.refreshDeviceCache(BleDevice.this.mDeviceGatt);
                } else {
                    BleDevice.this.refreshDeviceCache(BleDevice.this.mDeviceGatt);
                    BleDevice.this.mDeviceGatt.connect();
                }
            }
        }).start();
    }

    public void disconnect() {
        Log.v((String)"JavaBleDevice", (String)"Disconnecting from device");
        if (this.mDeviceGatt == null) {
            return;
        }
        this.mDeviceGatt.disconnect();
    }

    public void close() {
        Log.v((String)"JavaBleDevice", (String)"Closing device");
        if (this.mDeviceGatt == null) {
            return;
        }
        this.mDeviceGatt.close();
        this.mDeviceGatt = null;
        this.mConnectionState = BleDeviceState.ERROR;
    }

    public void subscribeDeviceEvents(BleDeviceCallback callback) {
        this.mDeviceCallback = callback;
    }

    public boolean sendCommand(byte[] cmdArray) {
        if (this.mTxCharacteristic == null) {
            Log.e((String)"JavaBleDevice", (String)"Cannot send command. Tx characteristic is null");
            return false;
        }
        if (this.mDeviceGatt == null) {
            Log.e((String)"JavaBleDevice", (String)"Cannot send command. Device GATT is null");
            return false;
        }
        if (this.mConnectionState != BleDeviceState.CONNECTED) {
            Log.e((String)"JavaBleDevice", (String)"Cannot send command. Device is disconnected");
            return false;
        }
        Log.v((String)"JavaBleDevice", (String)"Sending command");
        this.mTxCharacteristic.setValue(cmdArray);
        this.mTxCharacteristic.setWriteType(1);
        boolean res = this.mDeviceGatt.writeCharacteristic(this.mTxCharacteristic);
        if (res) {
            return true;
        }
        Log.w((String)"JavaBleDevice", (String)"Failed write tx characteristic. Try to rewrite");
        for (int k = 0; !res && k < 3; ++k) {
            try {
                Thread.sleep(300L);
            }
            catch (Exception e) {
                Log.w((String)"JavaBleDevice", (String)"Thread sleep raised interrupted exception");
                return false;
            }
            res = this.mDeviceGatt.writeCharacteristic(this.mTxCharacteristic);
        }
        if (!res) {
            Log.e((String)"JavaBleDevice", (String)"Failed write tx characteristic. Return");
        }
        return res;
    }
}

