/*
 * Decompiled with CFR 0.152.
 */
package com.neuromd.neurosdk.channels;

import com.neuromd.common.Assert;
import com.neuromd.neurosdk.Device;
import com.neuromd.neurosdk.channels.BaseChannel;
import com.neuromd.neurosdk.channels.ChannelInfo;
import com.neuromd.neurosdk.channels.Filter;

public class SignalChannel
extends BaseChannel<Double> {
    protected long mNativeObjPtr = 0L;

    public SignalChannel(Device device) {
        this.mNativeObjPtr = SignalChannel.create(device);
        Assert.ensures(this.mNativeObjPtr != 0L, "Signal channel native object is null");
        this.init();
    }

    public SignalChannel(Device device, ChannelInfo info) {
        this.mNativeObjPtr = SignalChannel.createWithInfo(device, info);
        Assert.ensures(this.mNativeObjPtr != 0L, "Signal channel native object is null");
        this.init();
    }

    public SignalChannel(Device device, Filter[] filters) {
        this.mNativeObjPtr = SignalChannel.createWithFilters(device, filters);
        Assert.ensures(this.mNativeObjPtr != 0L, "Signal channel native object is null");
        this.init();
    }

    public SignalChannel(Device device, Filter[] filters, ChannelInfo info) {
        this.mNativeObjPtr = SignalChannel.createWithFiltersAndInfo(device, filters, info);
        Assert.ensures(this.mNativeObjPtr != 0L, "Signal channel native object is null");
        this.init();
    }

    public void finalize() throws Throwable {
        this.deleteNative();
        super.finalize();
    }

    @Override
    public native ChannelInfo info();

    public native Double[] readData(long var1, long var3);

    @Override
    public native long totalLength();

    public native long bufferSize();

    @Override
    public native float samplingFrequency();

    public native Device underlyingDevice();

    public native double[] readFast(long var1, long var3);

    private static native long create(Device var0);

    private static native long createWithInfo(Device var0, ChannelInfo var1);

    private static native long createWithFilters(Device var0, Filter[] var1);

    private static native long createWithFiltersAndInfo(Device var0, Filter[] var1, ChannelInfo var2);

    private native void init();

    private native void deleteNative();

    static {
        System.loadLibrary("android-neurosdk");
    }
}

