/*
 * Decompiled with CFR 0.152.
 */
package com.neuromd.neurosdk;

import android.content.Context;
import com.neuromd.common.SubscribersNotifier;
import com.neuromd.neurosdk.Device;

public class DeviceScanner {
    private long mNativeObjPtr;
    public final SubscribersNotifier<Device> deviceFound = new SubscribersNotifier();
    public final SubscribersNotifier<Boolean> scanStateChanged = new SubscribersNotifier();

    public DeviceScanner(Context context) {
        this.mNativeObjPtr = this.create(context);
    }

    public void finalize() throws Throwable {
        if (this.mNativeObjPtr != 0L) {
            this.deleteNative(this.mNativeObjPtr);
            this.mNativeObjPtr = 0L;
        }
        super.finalize();
    }

    public void startScan(int timeout) {
        this.startScan(this.mNativeObjPtr, timeout);
    }

    public void stopScan() {
        this.stopScan(this.mNativeObjPtr);
    }

    public Device getDeviceByAddress(String address) {
        return this.findDeviceByAddress(this.mNativeObjPtr, address);
    }

    private void onDeviceFound(Device device) {
        this.deviceFound.sendNotification(this, device);
    }

    private void onScanStateChanged(boolean isScanning) {
        this.scanStateChanged.sendNotification(this, isScanning);
    }

    private native long create(Context var1);

    private native void deleteNative(long var1);

    private native void startScan(long var1, int var3);

    private native void stopScan(long var1);

    private native Device findDeviceByAddress(long var1, String var3);

    static {
        System.loadLibrary("android-neurosdk");
    }
}

