/*
 * Decompiled with CFR 0.152.
 */
package com.neuromd.neurosdk;

import com.neuromd.common.Assert;
import com.neuromd.common.SubscribersNotifier;
import com.neuromd.neurosdk.channels.ChannelInfo;
import com.neuromd.neurosdk.parameters.Command;
import com.neuromd.neurosdk.parameters.Parameter;
import com.neuromd.neurosdk.parameters.ParameterName;

public class Device {
    private long mNativeObjPtr = 0L;
    public final SubscribersNotifier<ParameterName> parameterChanged = new SubscribersNotifier();

    private Device(long nativeObjPtr) {
        this.mNativeObjPtr = nativeObjPtr;
        Assert.ensures(this.mNativeObjPtr != 0L, "Device pointer is null");
        this.init();
    }

    public void finalize() throws Throwable {
        if (this.mNativeObjPtr != 0L) {
            this.deleteDevice();
            this.mNativeObjPtr = 0L;
        }
        super.finalize();
    }

    public native void connect();

    public native void disconnect();

    public native ChannelInfo[] channels();

    public native Command[] commands();

    public native Parameter[] parameters();

    public native boolean execute(Command var1);

    public native <ParamType> ParamType readParam(ParameterName var1);

    public native boolean setParam(ParameterName var1, Object var2);

    private native void init();

    private native void deleteDevice();

    static {
        System.loadLibrary("android-neurosdk");
    }
}

