/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.oas.validator;

import com.networknt.jsonoverlay.Overlay;
import com.networknt.jsonoverlay.PositionInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ValidationResults {
    private List<ValidationItem> items = new ArrayList<ValidationItem>();

    public <V> void addInfo(String msg, Overlay<V> context) {
        this.items.add(new ValidationItem(Severity.INFO, msg, context));
    }

    public void addWarning(String msg, Overlay<?> context) {
        this.items.add(new ValidationItem(Severity.WARNING, msg, context));
    }

    public void addError(String msg, Overlay<?> context) {
        this.items.add(new ValidationItem(Severity.ERROR, msg, context));
    }

    public void add(ValidationResults results) {
        this.items.addAll(results.getItems());
    }

    public Collection<ValidationItem> getItems() {
        return this.items;
    }

    public Severity getSeverity() {
        Severity severity = Severity.NONE;
        for (ValidationItem item : this.items) {
            if (item.getSeverity().gt(severity) && (severity = item.getSeverity()) == Severity.MAX_SEVERITY) break;
        }
        return severity;
    }

    public static class ValidationItem {
        private Severity severity;
        private String msg;
        private PositionInfo positionInfo;

        public ValidationItem(Severity severity, String msg, Overlay<?> context) {
            this.severity = severity;
            this.msg = msg;
            this.positionInfo = context != null ? (PositionInfo)context.getPositionInfo().orElse(null) : null;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public String getMsg() {
            return this.msg;
        }

        public PositionInfo getPositionInfo() {
            return this.positionInfo;
        }

        public String toString() {
            String posString = this.positionInfo != null ? this.positionInfo.toString(true) + ": " : "";
            return posString + this.msg;
        }
    }

    public static enum Severity {
        NONE,
        INFO,
        WARNING,
        ERROR;

        public static final Severity MAX_SEVERITY;

        public boolean lt(Severity other) {
            return this.compareTo(other) < 0;
        }

        public boolean le(Severity other) {
            return this.compareTo(other) <= 0;
        }

        public boolean gt(Severity other) {
            return this.compareTo(other) > 0;
        }

        public boolean ge(Severity other) {
            return this.compareTo(other) >= 0;
        }

        static {
            MAX_SEVERITY = ERROR;
        }
    }
}

