/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.Pipe;
import java.nio.channels.SelectionKey;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.xnio.Xnio;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.ReadTimeoutException;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.conduits.Conduits;
import org.xnio.conduits.ReadReadyHandler;
import org.xnio.conduits.StreamSourceConduit;
import org.xnio.nio.Log;
import org.xnio.nio.NioHandle;
import org.xnio.nio.NioPipeStreamConnection;
import org.xnio.nio.NioXnio;
import org.xnio.nio.SelectorUtils;
import org.xnio.nio.WorkerThread;

final class NioPipeSourceConduit
extends NioHandle
implements StreamSourceConduit {
    private final Pipe.SourceChannel sourceChannel;
    private final NioPipeStreamConnection connection;
    private ReadReadyHandler readReadyHandler;
    private volatile int readTimeout;
    private long lastRead;
    private static final AtomicIntegerFieldUpdater<NioPipeSourceConduit> readTimeoutUpdater = AtomicIntegerFieldUpdater.newUpdater(NioPipeSourceConduit.class, "readTimeout");

    NioPipeSourceConduit(WorkerThread workerThread, SelectionKey selectionKey, NioPipeStreamConnection connection) {
        super(workerThread, selectionKey);
        this.connection = connection;
        this.sourceChannel = (Pipe.SourceChannel)selectionKey.channel();
    }

    @Override
    void handleReady(int ops) {
        try {
            this.readReadyHandler.readReady();
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    @Override
    public XnioWorker getWorker() {
        return this.getWorkerThread().getWorker();
    }

    @Override
    void forceTermination() {
        ReadReadyHandler read = this.readReadyHandler;
        if (read != null) {
            read.forceTermination();
        }
    }

    @Override
    void terminated() {
        ReadReadyHandler read = this.readReadyHandler;
        if (read != null) {
            read.terminated();
        }
    }

    int getAndSetReadTimeout(int newVal) {
        return readTimeoutUpdater.getAndSet(this, newVal);
    }

    int getReadTimeout() {
        return this.readTimeout;
    }

    private void checkReadTimeout(boolean xfer) throws ReadTimeoutException {
        int timeout2 = this.readTimeout;
        if (timeout2 > 0) {
            if (xfer) {
                this.lastRead = System.nanoTime();
            } else {
                long lastRead = this.lastRead;
                if (lastRead > 0L && (System.nanoTime() - lastRead) / 1000000L > (long)timeout2) {
                    throw Log.log.readTimeout();
                }
            }
        }
    }

    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        long res = target.transferFrom(this.sourceChannel, position, count);
        this.checkReadTimeout(res > 0L);
        return res;
    }

    @Override
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        return Conduits.transfer(this, count, throughBuffer, target);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int res;
        try {
            res = this.sourceChannel.read(dst);
        }
        catch (ClosedChannelException e) {
            return -1;
        }
        if (res != -1) {
            this.checkReadTimeout(res > 0);
        }
        return res;
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        long res;
        if (length == 1) {
            return this.read(dsts[offset]);
        }
        try {
            res = this.sourceChannel.read(dsts, offset, length);
        }
        catch (ClosedChannelException e) {
            return -1L;
        }
        if (res != -1L) {
            this.checkReadTimeout(res > 0L);
        }
        return res;
    }

    @Override
    public void terminateReads() throws IOException {
        if (this.connection.readClosed()) {
            try {
                this.sourceChannel.close();
            }
            catch (ClosedChannelException closedChannelException) {
            }
            finally {
                this.readTerminated();
            }
        }
    }

    void readTerminated() {
        ReadReadyHandler readReadyHandler = this.readReadyHandler;
        if (readReadyHandler != null) {
            try {
                readReadyHandler.terminated();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isReadShutdown() {
        return this.connection.isReadShutdown();
    }

    @Override
    public void resumeReads() {
        this.resume(1);
    }

    @Override
    public void suspendReads() {
        this.suspend(1);
    }

    @Override
    public void wakeupReads() {
        this.wakeup(1);
    }

    @Override
    public boolean isReadResumed() {
        return this.isResumed(1);
    }

    @Override
    public void awaitReadable() throws IOException {
        Xnio.checkBlockingAllowed();
        SelectorUtils.await((NioXnio)this.getWorker().getXnio(), this.sourceChannel, 1);
    }

    @Override
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        Xnio.checkBlockingAllowed();
        SelectorUtils.await((NioXnio)this.getWorker().getXnio(), this.sourceChannel, 1, time, timeUnit);
    }

    @Override
    public XnioIoThread getReadThread() {
        return this.getWorkerThread();
    }

    @Override
    public void setReadReadyHandler(ReadReadyHandler handler) {
        this.readReadyHandler = handler;
    }
}

