/*
 * Decompiled with CFR 0.152.
 */
package org.HdrHistogram;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.zip.DataFormatException;
import org.HdrHistogram.Base64Helper;
import org.HdrHistogram.EncodableHistogram;

public class HistogramLogReader {
    private final Scanner scanner;
    private double startTimeSec = 0.0;
    private boolean observedStartTime = false;
    private double baseTimeSec = 0.0;
    private boolean observedBaseTime = false;

    public HistogramLogReader(String inputFileName) throws FileNotFoundException {
        this.scanner = new Scanner(new File(inputFileName));
        this.initScanner();
    }

    public HistogramLogReader(InputStream inputStream2) {
        this.scanner = new Scanner(inputStream2);
        this.initScanner();
    }

    public HistogramLogReader(File inputFile) throws FileNotFoundException {
        this.scanner = new Scanner(inputFile);
        this.initScanner();
    }

    private void initScanner() {
        this.scanner.useLocale(Locale.US);
        this.scanner.useDelimiter("[, \\r\\n]");
    }

    public double getStartTimeSec() {
        return this.startTimeSec;
    }

    public EncodableHistogram nextIntervalHistogram(double startTimeSec, double endTimeSec) {
        return this.nextIntervalHistogram(startTimeSec, endTimeSec, false);
    }

    public EncodableHistogram nextAbsoluteIntervalHistogram(double absoluteStartTimeSec, double absoluteEndTimeSec) {
        return this.nextIntervalHistogram(absoluteStartTimeSec, absoluteEndTimeSec, true);
    }

    public EncodableHistogram nextIntervalHistogram() {
        return this.nextIntervalHistogram(0.0, 9.223372036854776E18, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EncodableHistogram nextIntervalHistogram(double rangeStartTimeSec, double rangeEndTimeSec, boolean absolute) {
        while (this.scanner.hasNextLine()) {
            try {
                if (this.scanner.hasNext("\\#.*")) {
                    if (this.scanner.hasNext("#\\[StartTime:")) {
                        this.scanner.next("#\\[StartTime:");
                        if (!this.scanner.hasNextDouble()) continue;
                        this.startTimeSec = this.scanner.nextDouble();
                        this.observedStartTime = true;
                        continue;
                    }
                    if (!this.scanner.hasNext("#\\[BaseTime:")) continue;
                    this.scanner.next("#\\[BaseTime:");
                    if (!this.scanner.hasNextDouble()) continue;
                    this.baseTimeSec = this.scanner.nextDouble();
                    this.observedBaseTime = true;
                    continue;
                }
                if (this.scanner.hasNext("\"StartTimestamp\".*")) continue;
                String tagString = null;
                if (this.scanner.hasNext("Tag\\=.*")) {
                    tagString = this.scanner.next("Tag\\=.*").substring(4);
                }
                double logTimeStampInSec = this.scanner.nextDouble();
                if (!this.observedStartTime) {
                    this.startTimeSec = logTimeStampInSec;
                    this.observedStartTime = true;
                }
                if (!this.observedBaseTime) {
                    this.baseTimeSec = logTimeStampInSec < this.startTimeSec - 3.1536E7 ? this.startTimeSec : 0.0;
                    this.observedBaseTime = true;
                }
                double absoluteStartTimeStampSec = logTimeStampInSec + this.baseTimeSec;
                double offsetStartTimeStampSec = absoluteStartTimeStampSec - this.startTimeSec;
                double intervalLengthSec = this.scanner.nextDouble();
                double absoluteEndTimeStampSec = absoluteStartTimeStampSec + intervalLengthSec;
                double startTimeStampToCheckRangeOn = absolute ? absoluteStartTimeStampSec : offsetStartTimeStampSec;
                if (startTimeStampToCheckRangeOn < rangeStartTimeSec) continue;
                if (startTimeStampToCheckRangeOn > rangeEndTimeSec) {
                    EncodableHistogram encodableHistogram = null;
                    return encodableHistogram;
                }
                this.scanner.nextDouble();
                String compressedPayloadString = this.scanner.next();
                ByteBuffer buffer = ByteBuffer.wrap(Base64Helper.parseBase64Binary(compressedPayloadString));
                EncodableHistogram histogram = EncodableHistogram.decodeFromCompressedByteBuffer(buffer, 0L);
                histogram.setStartTimeStamp((long)(absoluteStartTimeStampSec * 1000.0));
                histogram.setEndTimeStamp((long)(absoluteEndTimeStampSec * 1000.0));
                histogram.setTag(tagString);
                EncodableHistogram encodableHistogram = histogram;
                return encodableHistogram;
            }
            catch (NoSuchElementException ex) {
                EncodableHistogram encodableHistogram = null;
                return encodableHistogram;
            }
            catch (DataFormatException ex) {
                EncodableHistogram encodableHistogram = null;
                return encodableHistogram;
            }
            finally {
                this.scanner.nextLine();
            }
        }
        return null;
    }

    public boolean hasNext() {
        return this.scanner.hasNextLine();
    }
}

