/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.io;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.xnio.Buffers;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSinkChannel;

public class AsyncSenderImpl
implements Sender {
    private StreamSinkChannel channel;
    private final HttpServerExchange exchange;
    private PooledByteBuffer[] pooledBuffers = null;
    private FileChannel fileChannel;
    private IoCallback callback;
    private ByteBuffer[] buffer;
    private volatile Thread writeThread;
    private volatile Thread inCallback;
    private ChannelListener<StreamSinkChannel> writeListener;
    private TransferTask transferTask;

    public AsyncSenderImpl(HttpServerExchange exchange) {
        this.exchange = exchange;
    }

    @Override
    public void send(ByteBuffer buffer, IoCallback callback) {
        this.writeThread = Thread.currentThread();
        if (callback == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("callback");
        }
        if (!this.exchange.getConnection().isOpen()) {
            this.invokeOnException(callback, new ClosedChannelException());
            return;
        }
        if (this.exchange.isResponseComplete()) {
            this.invokeOnException(callback, new IOException(UndertowMessages.MESSAGES.responseComplete()));
        }
        if (this.buffer != null || this.fileChannel != null) {
            throw UndertowMessages.MESSAGES.dataAlreadyQueued();
        }
        long responseContentLength = this.exchange.getResponseContentLength();
        if (responseContentLength > 0L && (long)buffer.remaining() > responseContentLength) {
            this.invokeOnException(callback, UndertowLogger.ROOT_LOGGER.dataLargerThanContentLength(buffer.remaining(), responseContentLength));
            return;
        }
        StreamSinkChannel channel = this.channel;
        if (channel == null) {
            if (callback == IoCallback.END_EXCHANGE && responseContentLength == -1L && !this.exchange.getResponseHeaders().contains(Headers.TRANSFER_ENCODING)) {
                this.exchange.setResponseContentLength(buffer.remaining());
            }
            this.channel = channel = this.exchange.getResponseChannel();
            if (channel == null) {
                throw UndertowMessages.MESSAGES.responseChannelAlreadyProvided();
            }
        }
        this.callback = callback;
        if (this.inCallback == Thread.currentThread()) {
            this.buffer = new ByteBuffer[]{buffer};
            return;
        }
        try {
            do {
                if (buffer.remaining() == 0) {
                    callback.onComplete(this.exchange, this);
                    return;
                }
                int res = channel.write(buffer);
                if (res != 0) continue;
                this.buffer = new ByteBuffer[]{buffer};
                this.callback = callback;
                if (this.writeListener == null) {
                    this.initWriteListener();
                }
                channel.getWriteSetter().set(this.writeListener);
                channel.resumeWrites();
                return;
            } while (buffer.hasRemaining());
            this.invokeOnComplete();
        }
        catch (IOException e) {
            this.invokeOnException(callback, e);
        }
    }

    @Override
    public void send(ByteBuffer[] buffer, IoCallback callback) {
        this.writeThread = Thread.currentThread();
        if (callback == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("callback");
        }
        if (!this.exchange.getConnection().isOpen()) {
            this.invokeOnException(callback, new ClosedChannelException());
            return;
        }
        if (this.exchange.isResponseComplete()) {
            this.invokeOnException(callback, new IOException(UndertowMessages.MESSAGES.responseComplete()));
        }
        if (this.buffer != null) {
            throw UndertowMessages.MESSAGES.dataAlreadyQueued();
        }
        this.callback = callback;
        if (this.inCallback == Thread.currentThread()) {
            this.buffer = buffer;
            return;
        }
        long totalToWrite = Buffers.remaining(buffer);
        long responseContentLength = this.exchange.getResponseContentLength();
        if (responseContentLength > 0L && totalToWrite > responseContentLength) {
            this.invokeOnException(callback, UndertowLogger.ROOT_LOGGER.dataLargerThanContentLength(totalToWrite, responseContentLength));
            return;
        }
        StreamSinkChannel channel = this.channel;
        if (channel == null) {
            if (callback == IoCallback.END_EXCHANGE && responseContentLength == -1L && !this.exchange.getResponseHeaders().contains(Headers.TRANSFER_ENCODING)) {
                this.exchange.setResponseContentLength(totalToWrite);
            }
            this.channel = channel = this.exchange.getResponseChannel();
            if (channel == null) {
                throw UndertowMessages.MESSAGES.responseChannelAlreadyProvided();
            }
        }
        long total = totalToWrite;
        long written = 0L;
        try {
            do {
                long res = channel.write(buffer);
                written += res;
                if (res != 0L) continue;
                this.buffer = buffer;
                this.callback = callback;
                if (this.writeListener == null) {
                    this.initWriteListener();
                }
                channel.getWriteSetter().set(this.writeListener);
                channel.resumeWrites();
                return;
            } while (written < total);
            this.invokeOnComplete();
        }
        catch (IOException e) {
            this.invokeOnException(callback, e);
        }
    }

    @Override
    public void transferFrom(FileChannel source2, IoCallback callback) {
        this.writeThread = Thread.currentThread();
        if (callback == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("callback");
        }
        if (!this.exchange.getConnection().isOpen()) {
            this.invokeOnException(callback, new ClosedChannelException());
            return;
        }
        if (this.exchange.isResponseComplete()) {
            this.invokeOnException(callback, new IOException(UndertowMessages.MESSAGES.responseComplete()));
        }
        if (this.fileChannel != null || this.buffer != null) {
            throw UndertowMessages.MESSAGES.dataAlreadyQueued();
        }
        this.callback = callback;
        this.fileChannel = source2;
        if (this.inCallback == Thread.currentThread()) {
            return;
        }
        if (this.transferTask == null) {
            this.transferTask = new TransferTask();
        }
        if (this.exchange.isInIoThread()) {
            this.exchange.dispatch(this.transferTask);
            return;
        }
        this.transferTask.run();
    }

    @Override
    public void send(ByteBuffer buffer) {
        this.send(buffer, IoCallback.END_EXCHANGE);
    }

    @Override
    public void send(ByteBuffer[] buffer) {
        this.send(buffer, IoCallback.END_EXCHANGE);
    }

    @Override
    public void send(String data, IoCallback callback) {
        this.send(data, StandardCharsets.UTF_8, callback);
    }

    @Override
    public void send(String data, Charset charset, IoCallback callback) {
        ByteBuffer bytes;
        this.writeThread = Thread.currentThread();
        if (!this.exchange.getConnection().isOpen()) {
            this.invokeOnException(callback, new ClosedChannelException());
            return;
        }
        if (this.exchange.isResponseComplete()) {
            this.invokeOnException(callback, new IOException(UndertowMessages.MESSAGES.responseComplete()));
        }
        if ((bytes = ByteBuffer.wrap(data.getBytes(charset))).remaining() == 0) {
            callback.onComplete(this.exchange, this);
        } else {
            int i = 0;
            ByteBuffer[] bufs = null;
            while (bytes.hasRemaining()) {
                PooledByteBuffer pooled = this.exchange.getConnection().getByteBufferPool().allocate();
                if (bufs == null) {
                    int noBufs = (bytes.remaining() + pooled.getBuffer().remaining() - 1) / pooled.getBuffer().remaining();
                    this.pooledBuffers = new PooledByteBuffer[noBufs];
                    bufs = new ByteBuffer[noBufs];
                }
                this.pooledBuffers[i] = pooled;
                bufs[i] = pooled.getBuffer();
                Buffers.copy(pooled.getBuffer(), bytes);
                pooled.getBuffer().flip();
                ++i;
            }
            this.send(bufs, callback);
        }
    }

    @Override
    public void send(String data) {
        this.send(data, IoCallback.END_EXCHANGE);
    }

    @Override
    public void send(String data, Charset charset) {
        this.send(data, charset, IoCallback.END_EXCHANGE);
    }

    @Override
    public void close(final IoCallback callback) {
        block8: {
            try {
                StreamSinkChannel channel = this.channel;
                if (channel == null) {
                    if (this.exchange.getResponseContentLength() == -1L && !this.exchange.getResponseHeaders().contains(Headers.TRANSFER_ENCODING)) {
                        this.exchange.setResponseContentLength(0L);
                    }
                    this.channel = channel = this.exchange.getResponseChannel();
                    if (channel == null) {
                        throw UndertowMessages.MESSAGES.responseChannelAlreadyProvided();
                    }
                }
                channel.shutdownWrites();
                if (!channel.flush()) {
                    channel.getWriteSetter().set(ChannelListeners.flushingChannelListener(new ChannelListener<StreamSinkChannel>(){

                        @Override
                        public void handleEvent(StreamSinkChannel channel) {
                            if (callback != null) {
                                callback.onComplete(AsyncSenderImpl.this.exchange, AsyncSenderImpl.this);
                            }
                        }
                    }, new ChannelExceptionHandler<StreamSinkChannel>(){

                        @Override
                        public void handleException(StreamSinkChannel channel, IOException exception) {
                            try {
                                if (callback != null) {
                                    AsyncSenderImpl.this.invokeOnException(callback, exception);
                                }
                            }
                            finally {
                                IoUtils.safeClose((Closeable)channel);
                            }
                        }
                    }));
                    channel.resumeWrites();
                } else if (callback != null) {
                    callback.onComplete(this.exchange, this);
                }
            }
            catch (IOException e) {
                if (callback == null) break block8;
                this.invokeOnException(callback, e);
            }
        }
    }

    @Override
    public void close() {
        this.close(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeOnComplete() {
        block14: {
            while (true) {
                if (this.pooledBuffers != null) {
                    for (PooledByteBuffer buffer : this.pooledBuffers) {
                        buffer.close();
                    }
                    this.pooledBuffers = null;
                }
                IoCallback callback = this.callback;
                this.buffer = null;
                this.fileChannel = null;
                this.callback = null;
                this.writeThread = null;
                this.inCallback = Thread.currentThread();
                try {
                    callback.onComplete(this.exchange, this);
                }
                finally {
                    this.inCallback = null;
                }
                if (Thread.currentThread() != this.writeThread) {
                    return;
                }
                StreamSinkChannel channel = this.channel;
                if (this.buffer != null) {
                    long t2;
                    long total = t2 = Buffers.remaining(this.buffer);
                    long written = 0L;
                    try {
                        do {
                            long res = channel.write(this.buffer);
                            written += res;
                            if (res != 0L) continue;
                            if (this.writeListener == null) {
                                this.initWriteListener();
                            }
                            channel.getWriteSetter().set(this.writeListener);
                            channel.resumeWrites();
                            return;
                        } while (written < total);
                    }
                    catch (IOException e) {
                        this.invokeOnException(callback, e);
                    }
                    continue;
                }
                if (this.fileChannel == null) break block14;
                if (this.transferTask == null) {
                    this.transferTask = new TransferTask();
                }
                if (!this.transferTask.run(false)) break;
            }
            return;
        }
    }

    private void invokeOnException(IoCallback callback, IOException e) {
        if (this.pooledBuffers != null) {
            for (PooledByteBuffer buffer : this.pooledBuffers) {
                buffer.close();
            }
            this.pooledBuffers = null;
        }
        callback.onException(this.exchange, this, e);
    }

    private void initWriteListener() {
        this.writeListener = new ChannelListener<StreamSinkChannel>(){

            @Override
            public void handleEvent(StreamSinkChannel streamSinkChannel) {
                try {
                    long res;
                    long toWrite = Buffers.remaining(AsyncSenderImpl.this.buffer);
                    for (long written = 0L; written < toWrite; written += res) {
                        res = streamSinkChannel.write(AsyncSenderImpl.this.buffer, 0, AsyncSenderImpl.this.buffer.length);
                        if (res != 0L) continue;
                        return;
                    }
                    streamSinkChannel.suspendWrites();
                    AsyncSenderImpl.this.invokeOnComplete();
                }
                catch (IOException e) {
                    streamSinkChannel.suspendWrites();
                    AsyncSenderImpl.this.invokeOnException(AsyncSenderImpl.this.callback, e);
                }
            }
        };
    }

    public class TransferTask
    implements Runnable,
    ChannelListener<StreamSinkChannel> {
        public boolean run(boolean complete) {
            try {
                FileChannel source2 = AsyncSenderImpl.this.fileChannel;
                long pos = source2.position();
                long size = source2.size();
                StreamSinkChannel dest = AsyncSenderImpl.this.channel;
                if (dest == null) {
                    if (AsyncSenderImpl.this.callback == IoCallback.END_EXCHANGE && AsyncSenderImpl.this.exchange.getResponseContentLength() == -1L && !AsyncSenderImpl.this.exchange.getResponseHeaders().contains(Headers.TRANSFER_ENCODING)) {
                        AsyncSenderImpl.this.exchange.setResponseContentLength(size);
                    }
                    AsyncSenderImpl.this.channel = dest = AsyncSenderImpl.this.exchange.getResponseChannel();
                    if (dest == null) {
                        throw UndertowMessages.MESSAGES.responseChannelAlreadyProvided();
                    }
                }
                while (size - pos > 0L) {
                    long ret = dest.transferFrom(source2, pos, size - pos);
                    pos += ret;
                    if (ret != 0L) continue;
                    source2.position(pos);
                    dest.getWriteSetter().set(this);
                    dest.resumeWrites();
                    return false;
                }
                if (complete) {
                    AsyncSenderImpl.this.invokeOnComplete();
                }
            }
            catch (IOException e) {
                AsyncSenderImpl.this.invokeOnException(AsyncSenderImpl.this.callback, e);
            }
            return true;
        }

        @Override
        public void handleEvent(StreamSinkChannel channel) {
            channel.suspendWrites();
            channel.getWriteSetter().set(null);
            AsyncSenderImpl.this.exchange.dispatch(this);
        }

        @Override
        public void run() {
            this.run(true);
        }
    }
}

