/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.security;

import com.networknt.cache.CacheManager;
import com.networknt.client.ClientConfig;
import com.networknt.client.oauth.OauthHelper;
import com.networknt.client.oauth.SignKeyRequest;
import com.networknt.client.oauth.TokenKeyRequest;
import com.networknt.config.Config;
import com.networknt.config.ConfigException;
import com.networknt.config.JsonMapper;
import com.networknt.exception.ClientException;
import com.networknt.exception.ExpiredTokenException;
import com.networknt.security.SecurityConfig;
import com.networknt.security.TokenVerifier;
import com.networknt.status.Status;
import com.networknt.utility.FingerPrintUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.NumericDate;
import org.jose4j.jwt.consumer.ErrorCodeValidator;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.resolvers.JwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.keys.resolvers.X509VerificationKeyResolver;
import org.jose4j.lang.JoseException;
import org.owasp.encoder.Encode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtVerifier
extends TokenVerifier {
    static final Logger logger = LoggerFactory.getLogger(JwtVerifier.class);
    static final String GET_KEY_ERROR = "ERR10066";
    public static final String JWT = "jwt";
    public static final String JWK = "jwk";
    public static final String KID = "kid";
    public static final String SECURITY_CONFIG = "security";
    private static final int CACHE_EXPIRED_IN_MINUTES = 15;
    public static final String JWT_KEY_RESOLVER_X509CERT = "X509Certificate";
    public static final String JWT_KEY_RESOLVER_JWKS = "JsonWebKeySet";
    static SecurityConfig config;
    int secondsOfAllowedClockSkew;
    Boolean enableJwtCache;
    Boolean enableRelaxedKeyValidation;
    Boolean bootstrapFromKeyService;
    CacheManager cacheManager = CacheManager.getInstance();
    static Map<String, X509Certificate> certMap;
    static String audience;
    static Map<String, String> audienceMap;
    static List<String> fingerPrints;

    public JwtVerifier(SecurityConfig config) {
        JwtVerifier.config = config;
        this.secondsOfAllowedClockSkew = config.getClockSkewInSeconds();
        this.bootstrapFromKeyService = config.isBootstrapFromKeyService();
        this.enableRelaxedKeyValidation = config.isEnableRelaxedKeyValidation();
        this.enableJwtCache = config.isEnableJwtCache();
        String keyResolver = config.getKeyResolver();
        this.cacheCertificates();
        if (logger.isTraceEnabled()) {
            logger.trace("keyResolver = " + keyResolver + " bootstrapFromKeyService = " + this.bootstrapFromKeyService);
        }
        if (JWT_KEY_RESOLVER_JWKS.equals(keyResolver) && this.bootstrapFromKeyService.booleanValue()) {
            this.getJsonWebKeyMap();
        }
    }

    private void cacheCertificates() {
        certMap = new HashMap<String, X509Certificate>();
        fingerPrints = new ArrayList<String>();
        if (config.getCertificate() != null) {
            Map<String, Object> keyMap = config.getCertificate();
            for (String kid : keyMap.keySet()) {
                X509Certificate cert = null;
                try {
                    cert = this.readCertificate((String)keyMap.get(kid));
                }
                catch (Exception e) {
                    logger.error("Exception:", e);
                }
                certMap.put(kid, cert);
                fingerPrints.add(FingerPrintUtil.getCertFingerPrint(cert));
            }
        }
        logger.debug("Successfully cached Certificate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509Certificate readCertificate(String filename) throws Exception {
        InputStream inStream = null;
        X509Certificate cert = null;
        try {
            inStream = Config.getInstance().getInputStreamFromFile(filename);
            if (inStream != null) {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                cert = (X509Certificate)cf.generateCertificate(inStream);
            } else {
                logger.info("Certificate " + Encode.forJava(filename) + " not found.");
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", e);
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException ioe) {
                    logger.error("Exception: ", ioe);
                }
            }
        }
        return cert;
    }

    public JwtClaims verifyJwt(String jwt, boolean ignoreExpiry, boolean isToken, String pathPrefix, String requestPath, List<String> jwkServiceIds) throws InvalidJwtException, ExpiredTokenException {
        if (logger.isTraceEnabled()) {
            logger.trace("verifyJwt is called with ignoreExpiry = " + ignoreExpiry + " isToken = " + isToken + " pathPrefix = " + pathPrefix + " requestPath = " + requestPath + " jwkServiceIds = " + jwkServiceIds);
        }
        return this.verifyJwt(jwt, ignoreExpiry, isToken, pathPrefix, requestPath, jwkServiceIds, this::getKeyResolver);
    }

    public JwtClaims verifyJwt(String jwt, boolean ignoreExpiry, boolean isToken) throws InvalidJwtException, ExpiredTokenException {
        if (logger.isTraceEnabled()) {
            logger.trace("verifyJwt is called with ignoreExpiry = " + ignoreExpiry + " isToken = " + isToken);
        }
        return this.verifyJwt(jwt, ignoreExpiry, isToken, null, null, null, this::getKeyResolver);
    }

    public JwtClaims verifyJwt(String jwt, boolean ignoreExpiry, boolean isToken, String pathPrefix, String requestPath, List<String> jwkServiceIds, BiFunction<String, Object, VerificationKeyResolver> getKeyResolver) throws InvalidJwtException, ExpiredTokenException {
        String jwtJson = null;
        if (Boolean.TRUE.equals(this.enableJwtCache) && this.cacheManager != null && (jwtJson = pathPrefix != null ? (String)this.cacheManager.get(JWT, pathPrefix + ":" + jwt) : (String)this.cacheManager.get(JWT, jwt)) != null) {
            JwtClaims claims;
            try {
                claims = JwtClaims.parse(jwtJson);
            }
            catch (InvalidJwtException e) {
                logger.error("MalformedClaimException:", e);
                throw new InvalidJwtException("MalformedClaimException", new ErrorCodeValidator.Error(18, "Invalid JWT"), e, null);
            }
            JwtVerifier.checkExpiry(ignoreExpiry, claims, this.secondsOfAllowedClockSkew, null);
            return claims;
        }
        JwtConsumerBuilder pKeyBuilder = new JwtConsumerBuilder().setSkipAllValidators().setDisableRequireSignature().setSkipSignatureVerification();
        if (this.enableRelaxedKeyValidation.booleanValue()) {
            pKeyBuilder.setRelaxVerificationKeyValidation();
        }
        JwtConsumer consumer = pKeyBuilder.build();
        JwtContext jwtContext = consumer.process(jwt);
        JwtClaims claims = jwtContext.getJwtClaims();
        JsonWebStructure structure = jwtContext.getJoseObjects().get(0);
        String kid = structure.getKeyIdHeaderValue();
        JwtVerifier.checkExpiry(ignoreExpiry, claims, this.secondsOfAllowedClockSkew, jwtContext);
        this.validateAudience(claims, requestPath, jwkServiceIds, jwtContext);
        JwtConsumerBuilder jwtBuilder = new JwtConsumerBuilder().setRequireExpirationTime().setAllowedClockSkewInSeconds(315360000).setSkipDefaultAudienceValidation().setVerificationKeyResolver(getKeyResolver.apply(kid, jwkServiceIds != null ? jwkServiceIds : requestPath));
        if (this.enableRelaxedKeyValidation.booleanValue()) {
            jwtBuilder.setRelaxVerificationKeyValidation();
        }
        consumer = jwtBuilder.build();
        jwtContext = consumer.process(jwt);
        claims = jwtContext.getJwtClaims();
        if (Boolean.TRUE.equals(this.enableJwtCache) && this.cacheManager != null) {
            if (pathPrefix != null) {
                this.cacheManager.put(JWT, pathPrefix + ":" + jwt, claims.toJson());
            } else {
                this.cacheManager.put(JWT, jwt, claims.toJson());
            }
            if (this.cacheManager.getSize(JWT) > config.getJwtCacheFullSize()) {
                logger.warn("JWT cache exceeds the size limit " + config.getJwtCacheFullSize());
            }
        }
        return claims;
    }

    private void validateAudience(JwtClaims claims, String requestPath, List<String> jwkServiceIds, JwtContext context) throws InvalidJwtException {
        ClientConfig clientConfig = ClientConfig.get();
        String configuredAudience = null;
        try {
            if (requestPath == null && jwkServiceIds == null) {
                boolean r;
                configuredAudience = audience;
                if (configuredAudience != null && !(r = this.isJwtAudienceValid(claims, configuredAudience))) {
                    throw new InvalidJwtException("Invalid Audience", Collections.singletonList(new ErrorCodeValidator.Error(8, "Invalid Audience")), context);
                }
            } else if (jwkServiceIds != null && !jwkServiceIds.isEmpty()) {
                boolean r = this.isJwtAudienceValid(claims, jwkServiceIds);
                if (!r) {
                    throw new InvalidJwtException("Invalid Audience", Collections.singletonList(new ErrorCodeValidator.Error(8, "Invalid Audience")), context);
                }
            } else if (requestPath != null) {
                boolean r;
                String serviceId = this.getServiceIdByRequestPath(clientConfig, requestPath);
                if (serviceId == null) {
                    configuredAudience = audience;
                } else if (audienceMap != null && !audienceMap.isEmpty()) {
                    configuredAudience = audienceMap.get(serviceId);
                }
                if (configuredAudience != null && !(r = this.isJwtAudienceValid(claims, configuredAudience))) {
                    throw new InvalidJwtException("Invalid Audience", Collections.singletonList(new ErrorCodeValidator.Error(8, "Invalid Audience")), context);
                }
            }
        }
        catch (MalformedClaimException e) {
            logger.error("MalformedClaimException:", e);
            throw new InvalidJwtException("MalformedClaimException", new ErrorCodeValidator.Error(18, "Invalid Audience"), e, context);
        }
    }

    private boolean isJwtAudienceValid(JwtClaims claims, String audience) throws MalformedClaimException {
        if (claims.getAudience() == null) {
            return false;
        }
        if (claims.getAudience().size() == 1) {
            return claims.getAudience().get(0).equals(audience);
        }
        return claims.getAudience().contains(audience);
    }

    private boolean isJwtAudienceValid(JwtClaims claims, List<String> jwkServiceIds) throws MalformedClaimException {
        String serviceId;
        String configuredAudience;
        if (audienceMap == null || audienceMap.isEmpty()) {
            return true;
        }
        boolean validationResult = false;
        Iterator<String> iterator2 = jwkServiceIds.iterator();
        while (iterator2.hasNext() && ((configuredAudience = audienceMap.get(serviceId = iterator2.next())) == null || configuredAudience.isEmpty() || !(validationResult = this.isJwtAudienceValid(claims, configuredAudience)))) {
        }
        return validationResult;
    }

    private static void checkExpiry(boolean ignoreExpiry, JwtClaims claim, int allowedClockSkew, JwtContext context) throws ExpiredTokenException, InvalidJwtException {
        if (!ignoreExpiry) {
            try {
                if (NumericDate.now().getValue() - (long)allowedClockSkew >= claim.getExpirationTime().getValue()) {
                    logger.info("Cached jwt token is expired!");
                    throw new ExpiredTokenException("Token is expired");
                }
            }
            catch (MalformedClaimException e) {
                logger.error("MalformedClaimException:", e);
                throw new InvalidJwtException("MalformedClaimException", new ErrorCodeValidator.Error(18, "Invalid ExpirationTime Format"), e, context);
            }
        }
    }

    private VerificationKeyResolver getKeyResolver(String kid, Object requestPathOrJwkServiceIds) {
        X509Certificate certificate;
        String keyResolver = config.getKeyResolver();
        if (logger.isTraceEnabled()) {
            logger.trace("kid = " + kid + " requestPathOrJwkServiceIds = " + requestPathOrJwkServiceIds + " keyResolver = " + keyResolver);
        }
        X509Certificate x509Certificate = certificate = certMap == null ? null : certMap.get(kid);
        if (certificate != null) {
            X509VerificationKeyResolver x509VerificationKeyResolver = new X509VerificationKeyResolver(certificate);
            x509VerificationKeyResolver.setTryAllOnNoThumbHeader(true);
            return x509VerificationKeyResolver;
        }
        if (JWT_KEY_RESOLVER_JWKS.equals(keyResolver)) {
            ClientConfig clientConfig = ClientConfig.get();
            List jwkList = null;
            if (this.cacheManager != null) {
                List serviceIds;
                Object serviceId;
                if (requestPathOrJwkServiceIds == null) {
                    jwkList = (List)this.cacheManager.get(JWK, kid);
                } else if (requestPathOrJwkServiceIds instanceof String) {
                    String requestPath = (String)requestPathOrJwkServiceIds;
                    serviceId = this.getServiceIdByRequestPath(clientConfig, requestPath);
                    jwkList = serviceId == null ? (List)this.cacheManager.get(JWK, kid) : (List)this.cacheManager.get(JWK, (String)serviceId + ":" + kid);
                } else if (requestPathOrJwkServiceIds instanceof List && (serviceIds = (List)requestPathOrJwkServiceIds) != null && serviceIds.size() > 0) {
                    String serviceId2;
                    serviceId = serviceIds.iterator();
                    while (serviceId.hasNext() && ((jwkList = (List)this.cacheManager.get(JWK, (serviceId2 = (String)serviceId.next()) + ":" + kid)) == null || jwkList.size() <= 0)) {
                    }
                }
            }
            if (jwkList == null) {
                jwkList = this.getJsonWebKeySetForToken(kid, requestPathOrJwkServiceIds);
                if (jwkList == null || jwkList.isEmpty()) {
                    throw new RuntimeException("no JWK for kid: " + kid);
                }
                if (requestPathOrJwkServiceIds == null) {
                    this.cacheJwkList(jwkList, null);
                } else if (requestPathOrJwkServiceIds instanceof String) {
                    String serviceId = this.getServiceIdByRequestPath(clientConfig, (String)requestPathOrJwkServiceIds);
                    this.cacheJwkList(jwkList, serviceId);
                } else if (requestPathOrJwkServiceIds instanceof List) {
                    for (Object serviceId : (List)requestPathOrJwkServiceIds) {
                        this.cacheJwkList(jwkList, (String)serviceId);
                    }
                }
            }
            logger.debug("Got Json web key set from local cache");
            return new JwksVerificationKeyResolver(jwkList);
        }
        logger.error("Both X509Certificate and JWK are not configured.");
        return null;
    }

    private void cacheJwkList(List<JsonWebKey> jwkList, String serviceId) {
        if (this.cacheManager == null) {
            return;
        }
        for (JsonWebKey jwk : jwkList) {
            if (serviceId != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("cache the jwkList with serviceId {} kid {} and key {}", serviceId, jwk.getKeyId(), serviceId + ":" + jwk.getKeyId());
                }
                this.cacheManager.put(JWK, serviceId + ":" + jwk.getKeyId(), jwkList);
                continue;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("cache the jwkList with kid and only kid as key", (Object)jwk.getKeyId());
            }
            this.cacheManager.put(JWK, jwk.getKeyId(), jwkList);
        }
    }

    private String getServiceIdByRequestPath(ClientConfig clientConfig, String requestPath) {
        Map<String, String> pathPrefixServices = clientConfig.getPathPrefixServices();
        if (clientConfig.isMultipleAuthServers()) {
            if (pathPrefixServices == null || pathPrefixServices.size() == 0) {
                throw new ConfigException("pathPrefixServices property is missing or has an empty value in client.yml");
            }
            String serviceId = null;
            for (Map.Entry<String, String> entry : pathPrefixServices.entrySet()) {
                if (!requestPath.startsWith(entry.getKey())) continue;
                serviceId = entry.getValue();
            }
            if (serviceId == null) {
                throw new ConfigException("serviceId cannot be identified in client.yml with the requestPath = " + requestPath);
            }
            return serviceId;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void getJsonWebKeyMap() {
        ClientConfig clientConfig = ClientConfig.get();
        Map<String, Object> tokenConfig = clientConfig.getTokenConfig();
        Map keyConfig = (Map)tokenConfig.get("key");
        if (clientConfig.isMultipleAuthServers()) {
            Map serviceIdAuthServers = (Map)keyConfig.get("serviceIdAuthServers");
            if (serviceIdAuthServers != null && serviceIdAuthServers.size() > 0) {
                audienceMap = new HashMap<String, String>();
                for (Map.Entry entry : serviceIdAuthServers.entrySet()) {
                    String serviceId = (String)entry.getKey();
                    Map authServerConfig = (Map)entry.getValue();
                    if (authServerConfig.get("client_id") != null && authServerConfig.get("client_secret") != null) continue;
                    String audience = (String)authServerConfig.get("audience");
                    if (audience != null) {
                        if (logger.isTraceEnabled()) {
                            logger.trace("audience {} is mapped to serviceId {}", (Object)audience, (Object)serviceId);
                        }
                        audienceMap.put(serviceId, audience);
                    }
                    TokenKeyRequest keyRequest = new TokenKeyRequest(null, true, authServerConfig);
                    try {
                        List<JsonWebKey> jwkList;
                        if (logger.isDebugEnabled()) {
                            logger.debug("Getting Json Web Key list from {} for serviceId {}", (Object)keyRequest.getServerUrl(), entry.getKey());
                        }
                        String key = OauthHelper.getKey(keyRequest);
                        if (logger.isDebugEnabled()) {
                            logger.debug("Got Json Web Key = " + key);
                        }
                        if ((jwkList = new JsonWebKeySet(key).getJsonWebKeys()) == null || jwkList.isEmpty()) {
                            if (!logger.isErrorEnabled()) continue;
                            logger.error("Cannot get JWK from OAuth server.");
                            continue;
                        }
                        if (this.cacheManager == null) continue;
                        for (JsonWebKey jwk : jwkList) {
                            this.cacheManager.put(JWK, serviceId + ":" + jwk.getKeyId(), jwkList);
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug("Successfully cached JWK for serviceId {} kid {} with key {}", serviceId, jwk.getKeyId(), serviceId + ":" + jwk.getKeyId());
                        }
                    }
                    catch (JoseException ce) {
                        if (!logger.isErrorEnabled()) continue;
                        logger.error("Failed to get JWK set. - {} - {}", new Status(GET_KEY_ERROR, new Object[0]), ce.getMessage(), ce);
                    }
                    catch (ClientException ce) {
                        if (!logger.isErrorEnabled()) continue;
                        logger.error("Failed to get key. - {} - {} ", new Status(GET_KEY_ERROR, new Object[0]), ce.getMessage(), ce);
                    }
                }
                return;
            } else {
                logger.error("serviceIdAuthServers property is missing or empty in the token key configuration");
            }
            return;
        } else {
            audience = (String)keyConfig.get("audience");
            if (logger.isTraceEnabled()) {
                logger.trace("A single audience {} is configured in client.yml", (Object)audience);
            }
            TokenKeyRequest keyRequest = new TokenKeyRequest(null, true, null);
            try {
                List<JsonWebKey> jwkList;
                if (logger.isDebugEnabled()) {
                    logger.debug("Getting Json Web Key list from {}", (Object)keyRequest.getServerUrl());
                }
                String key = OauthHelper.getKey(keyRequest);
                if (logger.isDebugEnabled()) {
                    logger.debug("Got Json Web Key = " + key);
                }
                if ((jwkList = new JsonWebKeySet(key).getJsonWebKeys()) == null || jwkList.isEmpty()) {
                    throw new RuntimeException("cannot get JWK from OAuth server");
                }
                if (this.cacheManager == null) return;
                for (JsonWebKey jwk : jwkList) {
                    this.cacheManager.put(JWK, jwk.getKeyId(), jwkList);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Successfully cached JWK for kid {}", (Object)jwk.getKeyId());
                }
                return;
            }
            catch (JoseException ce) {
                if (!logger.isErrorEnabled()) return;
                logger.error("Failed to get JWK. - {} - {}", new Status(GET_KEY_ERROR, new Object[0]), ce.getMessage(), ce);
                return;
            }
            catch (ClientException ce) {
                if (!logger.isErrorEnabled()) return;
                logger.error("Failed to get Key. - {} - {}", new Status(GET_KEY_ERROR, new Object[0]), ce.getMessage(), ce);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<JsonWebKey> getJsonWebKeySetForToken(String kid, Object requestPathOrJwkServiceIds) {
        if (logger.isTraceEnabled()) {
            logger.trace("kid = " + kid + " requestPathOrJwkServiceIds = " + requestPathOrJwkServiceIds);
            if (requestPathOrJwkServiceIds instanceof List) {
                ((List)requestPathOrJwkServiceIds).forEach(logger::trace);
            }
        }
        ClientConfig clientConfig = ClientConfig.get();
        List<JsonWebKey> jwks = null;
        Map<String, Object> config = null;
        if (requestPathOrJwkServiceIds == null) return this.retrieveJwk(kid, null);
        if (!clientConfig.isMultipleAuthServers()) return this.retrieveJwk(kid, null);
        if (requestPathOrJwkServiceIds instanceof String) {
            String requestPath = (String)requestPathOrJwkServiceIds;
            Map<String, String> pathPrefixServices = clientConfig.getPathPrefixServices();
            if (pathPrefixServices == null) throw new ConfigException("pathPrefixServices property is missing or has an empty value in client.yml");
            if (pathPrefixServices.size() == 0) {
                throw new ConfigException("pathPrefixServices property is missing or has an empty value in client.yml");
            }
            String serviceId = null;
            for (Map.Entry<String, String> entry : pathPrefixServices.entrySet()) {
                if (!requestPath.startsWith(entry.getKey())) continue;
                serviceId = entry.getValue();
            }
            if (serviceId == null) {
                throw new ConfigException("serviceId cannot be identified in client.yml with the requestPath = " + requestPath);
            }
            config = this.getJwkConfig(clientConfig, serviceId);
            return this.retrieveJwk(kid, config);
        }
        if (!(requestPathOrJwkServiceIds instanceof List)) throw new ConfigException("requestPathOrJwkServiceIds must be a string or a list of strings");
        List jwkServiceIds = (List)requestPathOrJwkServiceIds;
        jwks = new ArrayList<JsonWebKey>();
        Iterator iterator2 = jwkServiceIds.iterator();
        while (iterator2.hasNext()) {
            String serviceId = (String)iterator2.next();
            config = this.getJwkConfig(clientConfig, serviceId);
            jwks.addAll(this.retrieveJwk(kid, config));
        }
        return jwks;
    }

    private List<JsonWebKey> retrieveJwk(String kid, Map<String, Object> config) {
        block7: {
            if (logger.isTraceEnabled() && config != null) {
                logger.trace("multiple oauth config based on path = " + JsonMapper.toJson(config));
            }
            TokenKeyRequest keyRequest = new TokenKeyRequest(kid, true, config);
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Getting Json Web Key list from {}", (Object)keyRequest.getServerUrl());
                }
                String key = OauthHelper.getKey(keyRequest);
                if (logger.isDebugEnabled()) {
                    logger.debug("Got Json Web Key {} from {} with path {}", key, keyRequest.getServerUrl(), keyRequest.getUri());
                }
                return new JsonWebKeySet(key).getJsonWebKeys();
            }
            catch (JoseException ce) {
                if (logger.isErrorEnabled()) {
                    logger.error("Failed to get JWK. - {} - {}", new Status(GET_KEY_ERROR, new Object[0]), ce.getMessage(), ce);
                }
            }
            catch (ClientException ce) {
                if (!logger.isErrorEnabled()) break block7;
                logger.error("Failed to get key - {} - {}", new Status(GET_KEY_ERROR, new Object[0]), ce.getMessage(), ce);
            }
        }
        return null;
    }

    public X509Certificate getCertForToken(String kid) {
        X509Certificate certificate;
        block6: {
            certificate = null;
            TokenKeyRequest keyRequest = new TokenKeyRequest(kid);
            try {
                if (logger.isWarnEnabled()) {
                    logger.warn("<Deprecated: use JsonWebKeySet instead> Getting raw certificate for kid: {} from {}", (Object)kid, (Object)keyRequest.getServerUrl());
                }
                String key = OauthHelper.getKey(keyRequest);
                if (logger.isWarnEnabled()) {
                    logger.warn("<Deprecated: use JsonWebKeySet instead> Got raw certificate {} for kid: {}", (Object)key, (Object)kid);
                }
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                certificate = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(key.getBytes(StandardCharsets.UTF_8)));
            }
            catch (CertificateException ce) {
                if (logger.isErrorEnabled()) {
                    logger.error("Failed to generate certificate: {}", (Object)ce.getMessage(), (Object)ce);
                }
            }
            catch (ClientException ce) {
                if (!logger.isErrorEnabled()) break block6;
                logger.error("Failed to get key: {}", (Object)ce.getMessage(), (Object)ce);
            }
        }
        return certificate;
    }

    public X509Certificate getCertForSign(String kid) {
        X509Certificate certificate;
        block4: {
            certificate = null;
            SignKeyRequest keyRequest = new SignKeyRequest(kid);
            try {
                String key = OauthHelper.getKey(keyRequest);
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                certificate = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(key.getBytes(StandardCharsets.UTF_8)));
            }
            catch (CertificateException ce) {
                if (logger.isErrorEnabled()) {
                    logger.error("Failed to generate certificate: {}", (Object)ce.getMessage(), (Object)ce);
                }
            }
            catch (ClientException ce) {
                if (!logger.isErrorEnabled()) break block4;
                logger.error("Failed to get key: {}", (Object)ce.getMessage(), (Object)ce);
            }
        }
        return certificate;
    }

    public List<String> getFingerPrints() {
        return fingerPrints;
    }
}

