/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.registry;

import com.networknt.registry.URL;
import com.networknt.registry.URLParamType;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLImpl
implements URL {
    private static final Logger logger = LoggerFactory.getLogger(URLImpl.class);
    private String protocol;
    private String host;
    private int port;
    private String path;
    private Map<String, String> parameters;
    private volatile transient Map<String, Number> numbers;

    public URLImpl(String protocol, String host, int port, String path) {
        this(protocol, host, port, path, new HashMap<String, String>());
    }

    public URLImpl() {
    }

    public URLImpl(String protocol, String host, int port, String path, Map<String, String> parameters) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.path = path;
        this.parameters = parameters;
    }

    public static URL valueOf(String url) {
        String protocol = null;
        String host = null;
        int port = 0;
        String path = null;
        HashMap<String, String> parameters = new HashMap<String, String>();
        int i = url.indexOf("?");
        if (i >= 0) {
            String[] parts;
            for (String part : parts = url.substring(i + 1).split("&")) {
                if ((part = part.trim()).length() <= 0) continue;
                int j = part.indexOf(61);
                if (j >= 0) {
                    parameters.put(part.substring(0, j), part.substring(j + 1));
                    continue;
                }
                parameters.put(part, part);
            }
            url = url.substring(0, i);
        }
        if ((i = url.indexOf("://")) >= 0) {
            if (i == 0) {
                throw new IllegalStateException("url missing protocol: \"" + url + "\"");
            }
            protocol = url.substring(0, i);
            url = url.substring(i + 3);
        } else {
            i = url.indexOf(":/");
            if (i >= 0) {
                if (i == 0) {
                    throw new IllegalStateException("url missing protocol: \"" + url + "\"");
                }
                protocol = url.substring(0, i);
                url = url.substring(i + 1);
            }
        }
        i = url.indexOf("/");
        if (i >= 0) {
            path = url.substring(i + 1);
            url = url.substring(0, i);
        }
        if ((i = url.indexOf(":")) >= 0 && i < url.length() - 1) {
            port = Integer.parseInt(url.substring(i + 1));
            url = url.substring(0, i);
        }
        if (url.length() > 0) {
            host = url;
        }
        if (port == 0) {
            if ("http".equalsIgnoreCase(protocol)) {
                port = 80;
            } else if ("https".equalsIgnoreCase(protocol)) {
                port = 443;
            } else {
                logger.error("Unknown protocol " + protocol);
            }
        }
        return new URLImpl(protocol, host, port, path, parameters);
    }

    private static String buildHostPortStr(String host, int defaultPort) {
        if (defaultPort <= 0) {
            return host;
        }
        int idx = host.indexOf(":");
        if (idx < 0) {
            return host + ":" + defaultPort;
        }
        int port = Integer.parseInt(host.substring(idx + 1));
        if (port <= 0) {
            return host.substring(0, idx + 1) + defaultPort;
        }
        return host;
    }

    @Override
    public URL createCopy() {
        HashMap<String, String> params = new HashMap<String, String>();
        if (this.parameters != null) {
            params.putAll(this.parameters);
        }
        return new URLImpl(this.protocol, this.host, this.port, this.path, params);
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String getVersion() {
        return this.getParameter(URLParamType.version.getName(), URLParamType.version.getValue());
    }

    @Override
    public String getGroup() {
        return this.getParameter(URLParamType.group.getName(), URLParamType.group.getValue());
    }

    @Override
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    @Override
    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    @Override
    public String getParameter(String name, String defaultValue) {
        String value = this.getParameter(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public String getMethodParameter(String methodName, String paramDesc, String name) {
        String value = this.getParameter("methodconfig." + methodName + "(" + paramDesc + ")." + name);
        if (value == null || value.length() == 0) {
            return this.getParameter(name);
        }
        return value;
    }

    @Override
    public String getMethodParameter(String methodName, String paramDesc, String name, String defaultValue) {
        String value = this.getMethodParameter(methodName, paramDesc, name);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public void addParameter(String name, String value) {
        if (name == null || value == null) {
            return;
        }
        this.parameters.put(name, value);
    }

    @Override
    public void removeParameter(String name) {
        if (name != null) {
            this.parameters.remove(name);
        }
    }

    @Override
    public void addParameters(Map<String, String> params) {
        this.parameters.putAll(params);
    }

    @Override
    public void addParameterIfAbsent(String name, String value) {
        if (this.hasParameter(name)) {
            return;
        }
        this.parameters.put(name, value);
    }

    @Override
    public Boolean getBooleanParameter(String name, boolean defaultValue) {
        String value = this.getParameter(name);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    @Override
    public Boolean getMethodParameter(String methodName, String paramDesc, String name, boolean defaultValue) {
        String value = this.getMethodParameter(methodName, paramDesc, name);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    @Override
    public Integer getIntParameter(String name, int defaultValue) {
        Number n = this.getNumbers().get(name);
        if (n != null) {
            return n.intValue();
        }
        String value = this.parameters.get(name);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        int i = Integer.parseInt(value);
        this.getNumbers().put(name, i);
        return i;
    }

    @Override
    public Integer getMethodParameter(String methodName, String paramDesc, String name, int defaultValue) {
        String key = methodName + "(" + paramDesc + ")." + name;
        Number n = this.getNumbers().get(key);
        if (n != null) {
            return n.intValue();
        }
        String value = this.getMethodParameter(methodName, paramDesc, name);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        int i = Integer.parseInt(value);
        this.getNumbers().put(key, i);
        return i;
    }

    @Override
    public String getUri() {
        return this.protocol + "://" + this.host + ":" + this.port + "/" + this.path;
    }

    @Override
    public String getIdentity() {
        return this.protocol + "://" + this.host + ":" + this.port + "/" + this.getParameter(URLParamType.group.getName(), URLParamType.group.getValue()) + "/" + this.getPath() + "/" + this.getParameter(URLParamType.version.getName(), URLParamType.version.getValue()) + "/" + this.getParameter(URLParamType.nodeType.getName(), URLParamType.nodeType.getValue());
    }

    @Override
    public boolean canServe(URL refUrl) {
        String refSerialize;
        String refVersion;
        if (refUrl == null || !this.getPath().equals(refUrl.getPath())) {
            return false;
        }
        if (!this.protocol.equals(refUrl.getProtocol())) {
            return false;
        }
        if (!"service".equals(this.getParameter(URLParamType.nodeType.getName()))) {
            return false;
        }
        String version = this.getParameter(URLParamType.version.getName(), URLParamType.version.getValue());
        if (!version.equals(refVersion = refUrl.getParameter(URLParamType.version.getName(), URLParamType.version.getValue()))) {
            return false;
        }
        String serialize = this.getParameter(URLParamType.serialize.getName(), URLParamType.serialize.getValue());
        return serialize.equals(refSerialize = refUrl.getParameter(URLParamType.serialize.getName(), URLParamType.serialize.getValue()));
    }

    @Override
    public String toFullStr() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getUri()).append("?");
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            builder.append(name).append("=").append(value).append("&");
        }
        return builder.toString();
    }

    public String toString() {
        return this.toSimpleString();
    }

    @Override
    public String toSimpleString() {
        return this.getUri() + "?group=" + this.getGroup();
    }

    @Override
    public boolean hasParameter(String key) {
        String p = this.getParameter(key);
        return p != null && p.trim().length() > 0;
    }

    @Override
    public String getServerPortStr() {
        return URLImpl.buildHostPortStr(this.host, this.port);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        URLImpl url = (URLImpl)o;
        if (this.port != url.getPort()) {
            return false;
        }
        if (this.protocol != null ? !this.protocol.equals(url.getProtocol()) : url.getProtocol() != null) {
            return false;
        }
        if (this.host != null ? !this.host.equals(url.getHost()) : url.getHost() != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(url.getPath()) : url.getPath() != null) {
            return false;
        }
        if (this.parameters != null ? !this.parameters.equals(url.getParameters()) : url.getParameters() != null) {
            return false;
        }
        return this.parameters != null ? this.parameters.equals(url.getParameters()) : url.getParameters() == null;
    }

    public int hashCode() {
        int result = this.protocol != null ? this.protocol.hashCode() : 0;
        result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
        result = 31 * result + this.port;
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
        result = 31 * result + (this.numbers != null ? this.numbers.hashCode() : 0);
        return result;
    }

    private Map<String, Number> getNumbers() {
        if (this.numbers == null) {
            this.numbers = new ConcurrentHashMap<String, Number>();
        }
        return this.numbers;
    }
}

