/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.oauth.key.handler;

import com.networknt.config.Config;
import com.networknt.handler.LightHttpHandler;
import com.networknt.security.SecurityConfig;
import io.undertow.server.HttpServerExchange;
import java.io.InputStream;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.PublicJsonWebKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Oauth2KeysGetHandler
implements LightHttpHandler {
    private static final Logger logger = LoggerFactory.getLogger(Oauth2KeysGetHandler.class);
    public static final String CONFIG_SECURITY = "openapi-security";

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        SecurityConfig config = SecurityConfig.load(CONFIG_SECURITY);
        Map<String, Object> certificateConfig = config.getCertificate();
        ArrayList<PublicJsonWebKey> jwkList = new ArrayList<PublicJsonWebKey>();
        for (Map.Entry<String, Object> entry : certificateConfig.entrySet()) {
            String kid = entry.getKey();
            String filename = (String)entry.getValue();
            if (filename == null) continue;
            InputStream inStream = Config.getInstance().getInputStreamFromFile(filename);
            try {
                if (inStream == null) continue;
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                X509Certificate certificate = (X509Certificate)cf.generateCertificate(inStream);
                PublicKey pk = certificate.getPublicKey();
                PublicJsonWebKey jwk = PublicJsonWebKey.Factory.newPublicJwk(pk);
                jwk.setKeyId(kid);
                jwkList.add(jwk);
            }
            finally {
                if (inStream == null) continue;
                inStream.close();
            }
        }
        JsonWebKeySet jwks = new JsonWebKeySet(jwkList);
        String jwksJson = jwks.toJson(JsonWebKey.OutputControlLevel.PUBLIC_ONLY);
        if (logger.isDebugEnabled()) {
            logger.debug(jwksJson);
        }
        exchange.setStatusCode(200);
        exchange.getResponseSender().send(jwksJson);
    }
}

