/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.oauth.cache;

import com.hazelcast.map.MapStore;
import com.networknt.oauth.cache.model.RefreshToken;
import com.networknt.service.SingletonServiceFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshTokenMapStore
implements MapStore<String, RefreshToken> {
    static final Logger logger = LoggerFactory.getLogger(RefreshTokenMapStore.class);
    static final DataSource ds = SingletonServiceFactory.getBean(DataSource.class);
    private static final String insert = "INSERT INTO refresh_token (user_id, user_type, roles, client_id, scope, remember, refresh_token) VALUES (?, ?, ?, ?, ?, ?, ?)";
    private static final String delete = "DELETE FROM refresh_token WHERE refresh_token = ?";
    private static final String select = "SELECT * FROM refresh_token WHERE refresh_token = ?";
    private static final String loadall = "SELECT refresh_token FROM refresh_token";

    @Override
    public synchronized void delete(String key) {
        if (logger.isDebugEnabled()) {
            logger.debug("Delete:" + key);
        }
        try (Connection connection = ds.getConnection();
             PreparedStatement stmt = connection.prepareStatement(delete);){
            stmt.setString(1, key);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            logger.error("Exception:", e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void store(String key, RefreshToken token) {
        if (logger.isDebugEnabled()) {
            logger.debug("Store:" + key);
        }
        if (this.load(key) == null) {
            try (Connection connection = ds.getConnection();
                 PreparedStatement stmt = connection.prepareStatement(insert);){
                stmt.setString(1, token.getUserId());
                stmt.setString(2, token.getUserType());
                stmt.setString(3, token.getRoles());
                stmt.setString(4, token.getClientId());
                stmt.setString(5, token.getScope());
                stmt.setString(6, token.getRemember());
                stmt.setString(7, token.getRefreshToken());
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                logger.error("Exception:", e);
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public synchronized void storeAll(Map<String, RefreshToken> map) {
        for (Map.Entry<String, RefreshToken> entry : map.entrySet()) {
            this.store(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public synchronized void deleteAll(Collection<String> keys2) {
        keys2.forEach(this::delete);
    }

    @Override
    public synchronized RefreshToken load(String key) {
        if (logger.isDebugEnabled()) {
            logger.debug("Load:" + key);
        }
        RefreshToken token = null;
        try (Connection connection = ds.getConnection();
             PreparedStatement stmt = connection.prepareStatement(select);){
            stmt.setString(1, key);
            try (ResultSet rs = stmt.executeQuery();){
                if (rs.next()) {
                    token = new RefreshToken();
                    token.setRefreshToken(key);
                    token.setUserId(rs.getString("user_id"));
                    token.setUserType(rs.getString("user_type"));
                    token.setRoles(rs.getString("roles"));
                    token.setClientId(rs.getString("client_id"));
                    token.setScope(rs.getString("scope"));
                    token.setRemember(rs.getString("remember"));
                }
            }
        }
        catch (SQLException e) {
            logger.error("Exception:", e);
            throw new RuntimeException(e);
        }
        return token;
    }

    @Override
    public synchronized Map<String, RefreshToken> loadAll(Collection<String> keys2) {
        HashMap<String, RefreshToken> result = new HashMap<String, RefreshToken>();
        for (String key : keys2) {
            result.put(key, this.load(key));
        }
        return result;
    }

    @Override
    public Iterable<String> loadAllKeys() {
        if (logger.isDebugEnabled()) {
            logger.debug("loadAllKeys is called");
        }
        ArrayList<String> keys2 = new ArrayList<String>();
        try (Connection connection = ds.getConnection();
             PreparedStatement stmt = connection.prepareStatement(loadall);
             ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                keys2.add(rs.getString("refresh_token"));
            }
        }
        catch (SQLException e) {
            logger.error("Exception:", e);
            throw new RuntimeException(e);
        }
        return keys2;
    }
}

