/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.ldap;

import com.networknt.ldap.LdapConfig;
import com.networknt.utility.ModuleRegistry;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapUtil {
    private static final Logger logger = LoggerFactory.getLogger(LdapUtil.class);
    private static final String contextFactory = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String CONFIG_LDAP = "ldap";
    private static final LdapConfig config = LdapConfig.load();

    public static boolean authenticate(String username, String password) {
        try {
            String dn = LdapUtil.getUid(username);
            if (dn != null) {
                if (LdapUtil.testBind(dn, password)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("user '" + username + "' authentication succeeded");
                    }
                    return true;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("user '" + username + "' authentication failed");
                }
                return false;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("user '" + username + "' not found");
            }
            return false;
        }
        catch (Exception e) {
            logger.error("Exception:", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> authorize(String username) {
        HashSet<String> groups2 = new HashSet<String>();
        DirContext ctx = null;
        try {
            Attribute memberOf;
            ctx = LdapUtil.ldapContext();
            SearchControls ctrls = new SearchControls();
            ctrls.setSearchScope(2);
            String filter = String.format(LdapUtil.config.searchFilter, username);
            NamingEnumeration<SearchResult> results = ctx.search(LdapUtil.config.searchBase, filter, ctrls);
            if (!results.hasMore()) {
                logger.error("Principal name '" + username + "' not found");
                Set<String> set = null;
                return set;
            }
            SearchResult result = results.next();
            if (logger.isDebugEnabled()) {
                logger.debug("distinguisedName: " + result.getNameInNamespace());
            }
            if ((memberOf = result.getAttributes().get("memberOf")) != null) {
                for (int idx = 0; idx < memberOf.size(); ++idx) {
                    groups2.add(memberOf.get(idx).toString());
                }
            }
        }
        catch (Exception e) {
            logger.error("Failed to authorize user " + username, e);
            Set<String> set = null;
            return set;
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (Exception exception) {}
        }
        return groups2;
    }

    public static Set<String> auth(String username, String password) {
        return null;
    }

    private static DirContext ldapContext() throws Exception {
        Hashtable<String, String> env = new Hashtable<String, String>();
        return LdapUtil.ldapContext(env);
    }

    private static DirContext ldapContext(Hashtable<String, String> env) throws Exception {
        env.put("java.naming.factory.initial", contextFactory);
        env.put("java.naming.provider.url", config.getUri());
        if (config.getUri().toUpperCase().startsWith("LDAPS://")) {
            env.put("java.naming.security.protocol", "ssl");
            env.put("java.naming.ldap.factory.socket", "com.networknt.ldap.LdapSSLSocketFactory");
        }
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", config.getPrincipal());
        env.put("java.naming.security.credentials", config.getCredential());
        InitialDirContext ctx = new InitialDirContext(env);
        return ctx;
    }

    private static String getUid(String username) throws Exception {
        String dn;
        DirContext ctx = LdapUtil.ldapContext();
        String filter = String.format(LdapUtil.config.searchFilter, username);
        SearchControls ctrl = new SearchControls();
        ctrl.setSearchScope(2);
        NamingEnumeration<SearchResult> answer = ctx.search(LdapUtil.config.searchBase, filter, ctrl);
        if (answer.hasMore()) {
            SearchResult result = answer.next();
            dn = result.getNameInNamespace();
        } else {
            dn = null;
        }
        answer.close();
        return dn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean testBind(String dn, String password) throws Exception {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", contextFactory);
        env.put("java.naming.provider.url", config.getUri());
        if (config.getUri().toUpperCase().startsWith("LDAPS://")) {
            env.put("java.naming.security.protocol", "ssl");
            env.put("java.naming.ldap.factory.socket", "com.networknt.ldap.LdapSSLSocketFactory");
        }
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", dn);
        env.put("java.naming.security.credentials", password);
        InitialDirContext ctx = null;
        try {
            ctx = new InitialDirContext(env);
        }
        catch (AuthenticationException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (Exception exception) {}
        }
        return true;
    }

    static {
        ModuleRegistry.registerModule(CONFIG_LDAP, LdapUtil.class.getName(), config.getMappedConfig(), null);
    }
}

