/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.ldap;

import com.networknt.config.Config;
import java.util.Map;

public class LdapConfig {
    public static final String CONFIG_NAME = "ldap";
    public static final String URI = "uri";
    public static final String DOMAIN = "domain";
    public static final String PRINCIPAL = "principal";
    public static final String CREDENTIAL = "credential";
    public static final String SEARCH_FILTER = "searchFilter";
    public static final String SEARCH_BASE = "searchBase";
    String uri;
    String domain;
    String principal;
    String credential;
    String searchFilter;
    String searchBase;
    private final Config config = Config.getInstance();
    private Map<String, Object> mappedConfig;

    private LdapConfig() {
        this(CONFIG_NAME);
    }

    private LdapConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
    }

    public static LdapConfig load() {
        return new LdapConfig();
    }

    public static LdapConfig load(String configName) {
        return new LdapConfig(configName);
    }

    void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setConfigData();
    }

    public Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public String getCredential() {
        return this.credential;
    }

    public void setCredential(String credential) {
        this.credential = credential;
    }

    public String getSearchFilter() {
        return this.searchFilter;
    }

    public void setSearchFilter(String searchFilter) {
        this.searchFilter = searchFilter;
    }

    public String getSearchBase() {
        return this.searchBase;
    }

    public void setSearchBase(String searchBase) {
        this.searchBase = searchBase;
    }

    private void setConfigData() {
        Object object = this.mappedConfig.get(URI);
        if (object != null) {
            this.uri = (String)object;
        }
        if ((object = this.mappedConfig.get(DOMAIN)) != null) {
            this.domain = (String)object;
        }
        if ((object = this.mappedConfig.get(PRINCIPAL)) != null) {
            this.principal = (String)object;
        }
        if ((object = this.mappedConfig.get(CREDENTIAL)) != null) {
            this.credential = (String)object;
        }
        if ((object = this.mappedConfig.get(SEARCH_FILTER)) != null) {
            this.searchFilter = (String)object;
        }
        if ((object = this.mappedConfig.get(SEARCH_BASE)) != null) {
            this.searchBase = (String)object;
        }
    }
}

