/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.http.client;

import com.networknt.client.ClientConfig;
import com.networknt.client.oauth.Jwt;
import com.networknt.client.oauth.TokenManager;
import com.networknt.config.TlsUtil;
import com.networknt.http.client.HttpMethod;
import com.networknt.http.client.JsonMapper;
import com.networknt.http.client.ssl.ClientX509ExtendedTrustManager;
import com.networknt.http.client.ssl.CompositeX509TrustManager;
import com.networknt.monad.Failure;
import com.networknt.monad.Result;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.owasp.encoder.Encode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientRequest {
    private static Logger logger = LoggerFactory.getLogger(HttpClientRequest.class);
    private static ClientConfig clientConfig = ClientConfig.get();
    HttpClient httpClient;
    public static final String TLS = "tls";
    static final String LOAD_TRUST_STORE = "loadTrustStore";
    static final String LOAD_KEY_STORE = "loadKeyStore";
    static final String LOAD_DEFAULT_TRUST = "loadDefaultTrustStore";
    static final String TRUST_STORE = "trustStore";
    static final String TRUST_STORE_PASS = "trustStorePass";
    static final String DEFAULT_CERT_PASS = "defaultCertPassword";
    static final String KEY_STORE = "keyStore";
    static final String KEY_STORE_PASS = "keyStorePass";
    static final String KEY_PASS = "keyPass";
    static final String TLS_VERSION = "tlsVersion";
    static final String KEY_STORE_PROPERTY = "javax.net.ssl.keyStore";
    static final String KEY_STORE_PASSWORD_PROPERTY = "javax.net.ssl.keyStorePassword";
    static final String TRUST_STORE_PROPERTY = "javax.net.ssl.trustStore";
    static final String TRUST_STORE_PASSWORD_PROPERTY = "javax.net.ssl.trustStorePassword";
    static final String TRUST_STORE_TYPE_PROPERTY = "javax.net.ssl.trustStoreType";
    private TokenManager tokenManager = TokenManager.getInstance();
    private String proxyHost = null;
    private int proxyPort;
    private Authenticator authenticator = null;
    private ExecutorService executorService = null;

    public void setProxy(String hostname, int port) {
        this.proxyHost = hostname;
        this.proxyPort = port;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    protected HttpClient buildHttpClient(ClientConfig clientConfig, boolean isHttps) {
        HttpClient.Builder clientBuilder = HttpClient.newBuilder().connectTimeout(Duration.ofMillis(clientConfig.getTimeout()));
        if (isHttps) {
            try {
                clientBuilder.sslContext(HttpClientRequest.createSSLContext());
            }
            catch (IOException e) {
                logger.error("cannot initial http client:" + e);
            }
        }
        if (clientConfig.getRequestEnableHttp2()) {
            clientBuilder.version(HttpClient.Version.HTTP_2);
        } else {
            clientBuilder.version(HttpClient.Version.HTTP_1_1);
        }
        if (this.proxyHost != null) {
            clientBuilder.proxy(ProxySelector.of(new InetSocketAddress(this.proxyHost, this.proxyPort == 0 ? 443 : this.proxyPort)));
        }
        if (this.authenticator != null) {
            clientBuilder.authenticator(this.authenticator);
        }
        if (this.executorService != null) {
            clientBuilder.executor(this.executorService);
        }
        return clientBuilder.build();
    }

    public HttpResponse<?> send(HttpRequest.Builder builder, HttpResponse.BodyHandler<?> handler) throws InterruptedException, IOException {
        HttpResponse<?> response = this.httpClient.send(builder.build(), handler);
        return response;
    }

    public CompletableFuture<? extends HttpResponse<?>> sendAsync(HttpRequest.Builder builder, HttpResponse.BodyHandler<?> handler) throws InterruptedException, IOException {
        CompletableFuture<HttpResponse<?>> response = this.httpClient.sendAsync(builder.build(), handler);
        return response;
    }

    public HttpRequest.Builder initBuilder(String url, HttpMethod method) throws Exception {
        return this.initBuilder(new URI(url), method, Optional.empty());
    }

    public HttpRequest.Builder initBuilder(String url, HttpMethod method, Optional<?> body) throws Exception {
        return this.initBuilder(new URI(url), method, body);
    }

    public HttpRequest.Builder initBuilder(URI uri, HttpMethod method) {
        return this.initBuilder(uri, method, Optional.empty());
    }

    public HttpRequest.Builder initBuilder(URI uri, HttpMethod method, Optional<?> body) {
        this.httpClient = this.buildHttpClient(clientConfig, "https".equals(uri.getScheme()));
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(uri);
        if (HttpMethod.DELETE.equals((Object)method)) {
            builder.DELETE();
        } else if (HttpMethod.POST.equals((Object)method)) {
            builder.POST(this.getBodyPublisher(body));
        } else if (HttpMethod.PUT.name().equals((Object)method)) {
            builder.PUT(this.getBodyPublisher(body));
        }
        return builder;
    }

    public void addAuthToken(HttpRequest.Builder builder, String token) {
        if (token != null && !((String)token).startsWith("Bearer ")) {
            token = ((String)token).toUpperCase().startsWith("BEARER ") ? "Bearer " + ((String)token).substring(7) : "Bearer " + (String)token;
        }
        builder.setHeader("Authorization", (String)token);
    }

    public void addRequestHeader(HttpRequest.Builder builder, String headerName, String headerValue) {
        builder.setHeader(headerName, headerValue);
    }

    public void addRequestHeaders(HttpRequest.Builder builder, Map<String, String> headers) {
        if (headers != null) {
            headers.forEach((k, v) -> builder.setHeader((String)k, (String)v));
        }
    }

    public void addTraceabilityId(HttpRequest.Builder builder, String traceabilityId) {
        builder.setHeader("X-Traceability-Id", traceabilityId);
    }

    public void addCorrelationId(HttpRequest.Builder builder, String correlationId) {
        builder.setHeader("X-Correlation-Id", correlationId);
    }

    public Result addCcToken(HttpRequest.Builder builder, String requestPath, String scopes, String serviceId) {
        Result<Jwt> result = this.tokenManager.getJwt(requestPath, scopes, serviceId);
        if (result.isFailure()) {
            return Failure.of(result.getError());
        }
        builder.setHeader("Authorization", "Bearer " + result.getResult().getJwt());
        return result;
    }

    public Result populateHeader(HttpRequest.Builder builder, String authToken, String requestPath, String scopes, String serviceId) {
        Result<Jwt> result = this.tokenManager.getJwt(requestPath, scopes, serviceId);
        if (result.isFailure()) {
            return Failure.of(result.getError());
        }
        if (authToken == null) {
            authToken = "Bearer " + result.getResult().getJwt();
        } else {
            builder.setHeader("X-Scope-Token", "Bearer " + result.getResult().getJwt());
        }
        this.addAuthToken(builder, (String)authToken);
        return result;
    }

    protected HttpRequest.BodyPublisher getBodyPublisher(Optional<?> body) {
        if (body.isPresent()) {
            if (body.get() instanceof String) {
                return HttpRequest.BodyPublishers.ofString((String)body.get());
            }
            if (body.get() instanceof Map) {
                return this.ofFormData((Map)body.get());
            }
            return HttpRequest.BodyPublishers.ofString(JsonMapper.toJson(body.get()));
        }
        return null;
    }

    private HttpRequest.BodyPublisher ofFormData(Map<Object, Object> data) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Object, Object> entry : data.entrySet()) {
            if (builder.length() > 0) {
                builder.append("&");
            }
            builder.append(URLEncoder.encode(entry.getKey().toString(), StandardCharsets.UTF_8));
            builder.append("=");
            builder.append(URLEncoder.encode(entry.getValue().toString(), StandardCharsets.UTF_8));
        }
        return HttpRequest.BodyPublishers.ofString(builder.toString());
    }

    public static SSLContext createSSLContext() throws IOException {
        SSLContext sslContext = null;
        KeyManager[] keyManagers = null;
        Map<String, Object> tlsMap = clientConfig.getTlsConfig();
        if (tlsMap != null) {
            try {
                Boolean loadKeyStore = (Boolean)tlsMap.get(LOAD_KEY_STORE);
                if (loadKeyStore != null && loadKeyStore.booleanValue()) {
                    String keyStoreName = System.getProperty(KEY_STORE_PROPERTY);
                    String keyStorePass = System.getProperty(KEY_STORE_PASSWORD_PROPERTY);
                    if (keyStoreName != null && keyStorePass != null) {
                        if (logger.isInfoEnabled()) {
                            logger.info("Loading key store from system property at " + Encode.forJava(keyStoreName));
                        }
                    } else {
                        keyStoreName = (String)tlsMap.get(KEY_STORE);
                        keyStorePass = (String)tlsMap.get(KEY_STORE_PASS);
                        if (keyStorePass == null) {
                            logger.error("Cannot load the config: keyStorePass from client.yml");
                        }
                        if (logger.isInfoEnabled()) {
                            logger.info("Loading key store from config at " + Encode.forJava(keyStoreName));
                        }
                    }
                    if (keyStoreName != null && keyStorePass != null) {
                        String keyPass = (String)tlsMap.get(KEY_PASS);
                        if (keyPass == null) {
                            logger.error("Cannot load the config: keyPass from client.yml");
                        }
                        KeyStore keyStore = TlsUtil.loadKeyStore(keyStoreName, keyStorePass.toCharArray());
                        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                        keyManagerFactory.init(keyStore, keyPass.toCharArray());
                        keyManagers = keyManagerFactory.getKeyManagers();
                    }
                }
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                throw new IOException("Unable to initialise KeyManager[]", e);
            }
            TrustManager[] trustManagers = null;
            Boolean loadDefaultTrust = (Boolean)tlsMap.get(LOAD_DEFAULT_TRUST);
            ArrayList<TrustManager> trustManagerList = new ArrayList<TrustManager>();
            try {
                Boolean loadTrustStore = (Boolean)tlsMap.get(LOAD_TRUST_STORE);
                if (loadTrustStore != null && loadTrustStore.booleanValue()) {
                    TrustManager[] defaultTrusts;
                    String trustStoreName = (String)tlsMap.get(TRUST_STORE);
                    String trustStorePass = (String)tlsMap.get(TRUST_STORE_PASS);
                    if (trustStorePass == null) {
                        logger.error("Cannot load the config: trustStorePass from client.yml");
                    }
                    if (logger.isInfoEnabled()) {
                        logger.info("Loading trust store from config at " + Encode.forJava(trustStoreName));
                    }
                    if (trustStoreName != null && trustStorePass != null) {
                        KeyStore trustStore = TlsUtil.loadTrustStore(trustStoreName, trustStorePass.toCharArray());
                        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                        trustManagerFactory.init(trustStore);
                        trustManagers = trustManagerFactory.getTrustManagers();
                    }
                    if (loadDefaultTrust != null && loadDefaultTrust.booleanValue() && (defaultTrusts = HttpClientRequest.loadDefaultTrustStore()) != null && defaultTrusts.length > 0) {
                        trustManagerList.addAll(Arrays.asList(defaultTrusts));
                    }
                    if (trustManagers != null && trustManagers.length > 0) {
                        trustManagerList.addAll(Arrays.asList(trustManagers));
                    }
                }
            }
            catch (Exception e) {
                throw new IOException("Unable to initialise TrustManager[]", e);
            }
            try {
                String tlsVersion = (String)tlsMap.get(TLS_VERSION);
                if (tlsVersion == null) {
                    tlsVersion = "TLSv1.2";
                }
                sslContext = SSLContext.getInstance(tlsVersion);
                if (loadDefaultTrust != null && loadDefaultTrust.booleanValue() && !trustManagerList.isEmpty()) {
                    TrustManager[] compositeTrustManagers = new TrustManager[]{new CompositeX509TrustManager(HttpClientRequest.convertTrustManagers(trustManagerList))};
                    sslContext.init(keyManagers, compositeTrustManagers, null);
                }
                if (trustManagers == null || trustManagers.length == 0) {
                    logger.error("No trust store is loaded. Please check client.yml");
                }
                TrustManager[] extendedTrustManagers = new TrustManager[]{new ClientX509ExtendedTrustManager(trustManagerList)};
                sslContext.init(keyManagers, extendedTrustManagers, null);
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new IOException("Unable to create and initialise the SSLContext", e);
            }
        } else {
            logger.error("TLS configuration section is missing in client.yml");
        }
        return sslContext;
    }

    public static List<X509TrustManager> convertTrustManagers(List<TrustManager> trustManagerList) {
        ArrayList<X509TrustManager> x509TrustManagers = new ArrayList<X509TrustManager>();
        for (TrustManager trustManager : trustManagerList) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            x509TrustManagers.add((X509TrustManager)trustManager);
        }
        return x509TrustManagers;
    }

    public static TrustManager[] loadDefaultTrustStore() throws Exception {
        String trustStoreType;
        String locationProperty;
        Path location = null;
        String password = "changeit";
        Map<String, Object> tlsMap = clientConfig.getTlsConfig();
        if (tlsMap != null && tlsMap.get(DEFAULT_CERT_PASS) != null) {
            password = (String)tlsMap.get(DEFAULT_CERT_PASS);
        }
        if (!StringUtils.isEmpty(locationProperty = System.getProperty(TRUST_STORE_PROPERTY))) {
            Path p = Paths.get(locationProperty, new String[0]);
            File f = p.toFile();
            if (f.exists() && f.isFile() && f.canRead()) {
                location = p;
            }
        } else {
            String javaHome = System.getProperty("java.home");
            location = Paths.get(javaHome, "lib", "security", "jssecacerts");
            if (!location.toFile().exists()) {
                location = Paths.get(javaHome, "lib", "security", "cacerts");
            }
        }
        if (!location.toFile().exists()) {
            logger.warn("Cannot find system default trust store");
            return null;
        }
        String trustStorePass = System.getProperty(TRUST_STORE_PASSWORD_PROPERTY);
        if (!StringUtils.isEmpty(trustStorePass)) {
            password = trustStorePass;
        }
        String type = !StringUtils.isEmpty(trustStoreType = System.getProperty(TRUST_STORE_TYPE_PROPERTY)) ? trustStoreType : KeyStore.getDefaultType();
        KeyStore trustStore = KeyStore.getInstance(type, Security.getProvider("SUN"));
        try (InputStream is = Files.newInputStream(location, new OpenOption[0]);){
            trustStore.load(is, password.toCharArray());
            logger.info("JDK default trust store loaded from : {} .", (Object)location);
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("PKIX");
        trustManagerFactory.init(trustStore);
        return trustManagerFactory.getTrustManagers();
    }
}

