/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.health;

import com.networknt.config.Config;
import java.util.Map;

public class HealthConfig {
    public static final String CONFIG_NAME = "health";
    private static final String ENABLED = "enabled";
    private static final String USE_JSON = "useJson";
    private static final String TIMEOUT = "timeout";
    private static final String DOWNSTREAM_ENABLED = "downstreamEnabled";
    private static final String DOWNSTREAM_HOST = "downstreamHost";
    private static final String DOWNSTREAM_PATH = "downstreamPath";
    private Map<String, Object> mappedConfig;
    private final Config config = Config.getInstance();
    boolean enabled;
    boolean useJson;
    int timeout;
    boolean downstreamEnabled;
    String downstreamHost;
    String downstreamPath;

    private HealthConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
    }

    private HealthConfig() {
        this(CONFIG_NAME);
    }

    public static HealthConfig load(String configName) {
        return new HealthConfig(configName);
    }

    public static HealthConfig load() {
        return new HealthConfig();
    }

    public void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setConfigData();
    }

    public void reload(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isUseJson() {
        return this.useJson;
    }

    public void setUseJson(boolean useJson) {
        this.useJson = useJson;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout2) {
        this.timeout = timeout2;
    }

    public boolean isDownstreamEnabled() {
        return this.downstreamEnabled;
    }

    public void setDownstreamEnabled(boolean downstreamEnabled) {
        this.downstreamEnabled = downstreamEnabled;
    }

    public String getDownstreamHost() {
        return this.downstreamHost;
    }

    public void setDownstreamHost(String downstreamHost) {
        this.downstreamHost = downstreamHost;
    }

    public String getDownstreamPath() {
        return this.downstreamPath;
    }

    public void setDownstreamPath(String downstreamPath) {
        this.downstreamPath = downstreamPath;
    }

    public Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    Config getConfig() {
        return this.config;
    }

    private void setConfigData() {
        if (this.getMappedConfig() != null) {
            Object object = this.getMappedConfig().get(ENABLED);
            if (object != null) {
                this.enabled = Config.loadBooleanValue(ENABLED, object);
            }
            if ((object = this.getMappedConfig().get(USE_JSON)) != null) {
                this.useJson = Config.loadBooleanValue(USE_JSON, object);
            }
            if ((object = this.getMappedConfig().get(TIMEOUT)) != null) {
                this.timeout = Config.loadIntegerValue(TIMEOUT, object);
            }
            if ((object = this.getMappedConfig().get(DOWNSTREAM_ENABLED)) != null) {
                this.downstreamEnabled = Config.loadBooleanValue(DOWNSTREAM_ENABLED, object);
            }
            if ((object = this.getMappedConfig().get(DOWNSTREAM_HOST)) != null) {
                this.downstreamHost = (String)object;
            }
            if ((object = this.getMappedConfig().get(DOWNSTREAM_PATH)) != null) {
                this.downstreamPath = (String)object;
            }
        }
    }
}

