/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.handler;

import com.fasterxml.jackson.core.type.TypeReference;
import com.networknt.config.Config;
import com.networknt.config.ConfigException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestInjectionConfig {
    private static final Logger LOG = LoggerFactory.getLogger(RequestInjectionConfig.class);
    public static final String CONFIG_NAME = "request-injection";
    private static final String ENABLED = "enabled";
    private static final String APPLIED_BODY_INJECTION_PATH_PREFIXES = "appliedBodyInjectionPathPrefixes";
    private static final String MAX_BUFFERS = "maxBuffers";
    private boolean enabled;
    private List<String> appliedBodyInjectionPathPrefixes;
    private int maxBuffers;
    private Map<String, Object> mappedConfig;
    private final Config config = Config.getInstance();

    public RequestInjectionConfig() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setConfigData();
        this.setConfigList();
    }

    public RequestInjectionConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
        this.setConfigList();
    }

    static RequestInjectionConfig load() {
        return new RequestInjectionConfig();
    }

    static RequestInjectionConfig load(String configName) {
        return new RequestInjectionConfig(configName);
    }

    void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setConfigData();
        this.setConfigList();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getMaxBuffers() {
        return this.maxBuffers;
    }

    public List<String> getAppliedBodyInjectionPathPrefixes() {
        return this.appliedBodyInjectionPathPrefixes;
    }

    Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    private void setConfigData() {
        Object object = this.getMappedConfig().get(ENABLED);
        if (object != null) {
            this.enabled = Config.loadBooleanValue(ENABLED, object);
        }
        if ((object = this.getMappedConfig().get(MAX_BUFFERS)) != null) {
            this.maxBuffers = Config.loadIntegerValue(MAX_BUFFERS, object);
        }
    }

    private void setConfigList() {
        if (this.mappedConfig != null && this.mappedConfig.get(APPLIED_BODY_INJECTION_PATH_PREFIXES) != null) {
            Object object = this.mappedConfig.get(APPLIED_BODY_INJECTION_PATH_PREFIXES);
            this.appliedBodyInjectionPathPrefixes = new ArrayList<String>();
            if (object instanceof String) {
                String s2 = (String)object;
                s2 = s2.trim();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("s = " + s2);
                }
                if (s2.startsWith("[")) {
                    try {
                        this.appliedBodyInjectionPathPrefixes = Config.getInstance().getMapper().readValue(s2, new TypeReference<List<String>>(){});
                    }
                    catch (Exception e) {
                        throw new ConfigException("could not parse the appliedBodyInjectionPathPrefixes json with a list of strings.");
                    }
                } else {
                    this.appliedBodyInjectionPathPrefixes = Arrays.asList(s2.split("\\s*,\\s*"));
                }
            } else if (object instanceof List) {
                List prefixes = (List)object;
                prefixes.forEach(item -> this.appliedBodyInjectionPathPrefixes.add((String)item));
            } else {
                throw new ConfigException("appliedBodyInjectionPathPrefixes must be a string or a list of strings.");
            }
        }
    }
}

