/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.cors;

import com.networknt.config.Config;
import com.networknt.cors.CorsConfig;
import com.networknt.cors.CorsHeaders;
import com.networknt.cors.CorsUtil;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import java.util.Collection;

public class CorsHttpHandler
implements MiddlewareHandler {
    public static CorsConfig config;
    private static Collection<String> allowedOrigins;
    private static Collection<String> allowedMethods;
    private volatile HttpHandler next;
    private static final long ONE_HOUR_IN_SECONDS = 3600L;

    public CorsHttpHandler() {
        config = CorsConfig.load();
        allowedOrigins = config.getAllowedOrigins();
        allowedMethods = config.getAllowedMethods();
        if (logger.isInfoEnabled()) {
            logger.info("CorsHttpHandler is loaded.");
        }
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        HeaderMap headers;
        if (logger.isDebugEnabled()) {
            logger.debug("CorsHttpHandler.handleRequest starts.");
        }
        if (CorsUtil.isCoreRequest(headers = exchange.getRequestHeaders())) {
            if (CorsUtil.isPreflightedRequest(exchange)) {
                this.handlePreflightRequest(exchange);
                return;
            }
            this.setCorsResponseHeaders(exchange);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("CorsHttpHandler.handleRequest ends.");
        }
        Handler.next(exchange, this.next);
    }

    private void handlePreflightRequest(HttpServerExchange exchange) throws Exception {
        this.setCorsResponseHeaders(exchange);
        ResponseCodeHandler.HANDLE_200.handleRequest(exchange);
    }

    private void setCorsResponseHeaders(HttpServerExchange exchange) throws Exception {
        HeaderMap headers = exchange.getRequestHeaders();
        if (headers.contains(Headers.ORIGIN) && CorsUtil.matchOrigin(exchange, allowedOrigins) != null) {
            exchange.getResponseHeaders().addAll(CorsHeaders.ACCESS_CONTROL_ALLOW_ORIGIN, headers.get(Headers.ORIGIN));
            exchange.getResponseHeaders().add(Headers.VARY, "Origin");
        }
        exchange.getResponseHeaders().addAll(CorsHeaders.ACCESS_CONTROL_ALLOW_METHODS, allowedMethods);
        HeaderValues requestedHeaders = headers.get(CorsHeaders.ACCESS_CONTROL_REQUEST_HEADERS);
        if (requestedHeaders != null && !requestedHeaders.isEmpty()) {
            exchange.getResponseHeaders().addAll(CorsHeaders.ACCESS_CONTROL_ALLOW_HEADERS, requestedHeaders);
        } else {
            exchange.getResponseHeaders().add(CorsHeaders.ACCESS_CONTROL_ALLOW_HEADERS, "Content-Type");
            exchange.getResponseHeaders().add(CorsHeaders.ACCESS_CONTROL_ALLOW_HEADERS, "WWW-Authenticate");
            exchange.getResponseHeaders().add(CorsHeaders.ACCESS_CONTROL_ALLOW_HEADERS, "Authorization");
        }
        exchange.getResponseHeaders().add(CorsHeaders.ACCESS_CONTROL_ALLOW_CREDENTIALS, "true");
        exchange.getResponseHeaders().add(CorsHeaders.ACCESS_CONTROL_MAX_AGE, 3600L);
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return config.isEnabled();
    }

    @Override
    public void register() {
        ModuleRegistry.registerModule("cors", CorsHttpHandler.class.getName(), Config.getInstance().getJsonMapConfigNoCache("cors"), null);
    }

    @Override
    public void reload() {
        config.reload();
        ModuleRegistry.registerModule("cors", CorsHttpHandler.class.getName(), config.getMappedConfig(), null);
        if (logger.isInfoEnabled()) {
            logger.info("CorsHttpHandler is enabled.");
        }
    }
}

