/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.correlation;

import com.networknt.config.Config;
import java.util.Map;

public class CorrelationConfig {
    public static final String CONFIG_NAME = "correlation";
    private static final String ENABLED = "enabled";
    private static final String AUTOGEN_CORRELATION_ID = "autogenCorrelationID";
    private Map<String, Object> mappedConfig;
    private final Config config = Config.getInstance();
    boolean enabled;
    boolean autogenCorrelationID;

    private CorrelationConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
    }

    private CorrelationConfig() {
        this(CONFIG_NAME);
    }

    public static CorrelationConfig load(String configName) {
        return new CorrelationConfig(configName);
    }

    public static CorrelationConfig load() {
        return new CorrelationConfig();
    }

    public void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setConfigData();
    }

    public void reload(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isAutogenCorrelationID() {
        return this.autogenCorrelationID;
    }

    public void setAutogenCorrelationID(boolean autogenCorrelationID) {
        this.autogenCorrelationID = autogenCorrelationID;
    }

    public Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    Config getConfig() {
        return this.config;
    }

    private void setConfigData() {
        if (this.getMappedConfig() != null) {
            Object object = this.getMappedConfig().get(ENABLED);
            if (object != null) {
                this.enabled = Config.loadBooleanValue(ENABLED, object);
            }
            if ((object = this.getMappedConfig().get(AUTOGEN_CORRELATION_ID)) != null) {
                this.autogenCorrelationID = Config.loadBooleanValue(AUTOGEN_CORRELATION_ID, object);
            }
        }
    }
}

