/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.oauth;

import com.networknt.client.ClientConfig;
import com.networknt.client.oauth.KeyRequest;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignKeyRequest
extends KeyRequest {
    private static Logger logger = LoggerFactory.getLogger(SignKeyRequest.class);
    @Deprecated
    public static String SIGN = "sign";

    public SignKeyRequest(String kid) {
        super(kid);
        Map<String, Object> signConfig = ClientConfig.get().getSignConfig();
        if (signConfig != null) {
            Map keyConfig = (Map)signConfig.get("key");
            if (keyConfig != null) {
                this.setServerUrl((String)keyConfig.get("server_url"));
                this.setProxyHost((String)signConfig.get("proxyHost"));
                int port = signConfig.get("proxyPort") == null ? 443 : (Integer)signConfig.get("proxyPort");
                this.setProxyPort(port);
                this.setServiceId((String)keyConfig.get("serviceId"));
                Object object = keyConfig.get("enableHttp2");
                this.setEnableHttp2(object != null && (Boolean)object != false);
                this.setUri(keyConfig.get("uri") + "/" + kid);
                this.setClientId((String)keyConfig.get("client_id"));
                this.setClientSecret((String)keyConfig.get("client_secret"));
                if (keyConfig.get("audience") != null) {
                    this.setAudience((String)keyConfig.get("audience"));
                }
            } else {
                logger.error("Error: could not find key section in sign of oauth in client.yml");
            }
        } else {
            logger.error("Error: could not find sign section of oauth in client.yml");
        }
    }
}

