/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.cache;

import com.fasterxml.jackson.core.type.TypeReference;
import com.networknt.cache.CacheItem;
import com.networknt.config.Config;
import com.networknt.config.ConfigException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheConfig {
    private static final Logger logger = LoggerFactory.getLogger(CacheConfig.class);
    public static final String CONFIG_NAME = "cache";
    public static final String CACHES = "caches";
    public static final String CACHE_NAME = "cacheName";
    public static final String EXPIRY_IN_MINUTES = "expiryInMinutes";
    public static final String MAX_SIZE = "maxSize";
    List<CacheItem> caches;
    private final Config config = Config.getInstance();
    private Map<String, Object> mappedConfig;

    private CacheConfig() {
        this(CONFIG_NAME);
    }

    private CacheConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigList();
    }

    public static CacheConfig load() {
        return new CacheConfig();
    }

    public static CacheConfig load(String configName) {
        return new CacheConfig(configName);
    }

    void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setConfigList();
    }

    public Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    public List<CacheItem> getCaches() {
        return this.caches;
    }

    public void setCaches(List<CacheItem> caches) {
        this.caches = caches;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setConfigList() {
        if (this.mappedConfig.get(CACHES) == null) return;
        Object object = this.mappedConfig.get(CACHES);
        this.caches = new ArrayList<CacheItem>();
        if (object instanceof String) {
            String s2 = (String)object;
            s2 = s2.trim();
            if (logger.isTraceEnabled()) {
                logger.trace("caches s = " + s2);
            }
            if (!s2.startsWith("[")) throw new ConfigException("caches must be a list of string object map.");
            try {
                this.caches = Config.getInstance().getMapper().readValue(s2, new TypeReference<List<CacheItem>>(){});
                return;
            }
            catch (Exception e) {
                throw new ConfigException("could not parse the caches json with a list of string and object.");
            }
        } else {
            if (!(object instanceof List)) throw new ConfigException("caches must be a list of string object map.");
            List values2 = (List)object;
            for (Map value : values2) {
                CacheItem cacheItem = new CacheItem();
                cacheItem.setCacheName((String)value.get(CACHE_NAME));
                cacheItem.setMaxSize((Integer)value.get(MAX_SIZE));
                cacheItem.setExpiryInMinutes((Integer)value.get(EXPIRY_IN_MINUTES));
                this.caches.add(cacheItem);
            }
        }
    }
}

