/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.body;

import com.networknt.body.BodyConfig;
import com.networknt.common.ContentType;
import com.networknt.handler.BuffersUtils;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.handler.ResponseInterceptor;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseBodyInterceptor
implements ResponseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseBodyInterceptor.class);
    private final BodyConfig config;
    private volatile HttpHandler next;

    public ResponseBodyInterceptor() {
        if (LOG.isInfoEnabled()) {
            LOG.info("ResponseBodyInterceptor is loaded");
        }
        this.config = BodyConfig.load();
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return this.config.isEnabled();
    }

    @Override
    public void register() {
        ModuleRegistry.registerModule("body", ResponseBodyInterceptor.class.getName(), this.config.getMappedConfig(), null);
    }

    @Override
    public void reload() {
        this.config.reload();
        ModuleRegistry.registerModule("body", ResponseBodyInterceptor.class.getName(), this.config.getMappedConfig(), null);
        if (LOG.isInfoEnabled()) {
            LOG.info("ResponseBodyInterceptor is reloaded.");
        }
    }

    @Override
    public boolean isRequiredContent() {
        return true;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        PooledByteBuffer[] existing;
        if (LOG.isDebugEnabled()) {
            LOG.debug("ResponseBodyInterceptor.handleRequest starts.");
        }
        if (this.shouldAttachBody(exchange.getResponseHeaders()) && (existing = this.getBuffer(exchange)) != null) {
            boolean attached;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Attach response body requirement is met and the byte buffer pool exists.");
            }
            String completeBody = BuffersUtils.toString(existing, StandardCharsets.UTF_8);
            String contentType = exchange.getResponseHeaders().getFirst(Headers.CONTENT_TYPE);
            if (LOG.isTraceEnabled()) {
                if (this.config.isLogFullResponseBody()) {
                    LOG.trace("contentType = " + contentType + " response body = " + completeBody);
                } else {
                    LOG.trace("contentType = " + contentType + " response body = " + (completeBody.length() > 16384 ? completeBody.substring(0, 16384) : completeBody));
                }
            }
            if (!(attached = this.handleBody(exchange, completeBody, contentType)) && LOG.isErrorEnabled()) {
                LOG.error("Failed to attach the request body to the exchange!");
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("ResponseBodyInterceptor.handleRequest ends.");
        }
    }

    private boolean handleBody(HttpServerExchange ex, String body, String contentType) {
        if (this.isJsonData(contentType)) {
            return this.attachJsonBody(ex, body);
        }
        if (this.isXmlData(contentType)) {
            return this.attachXmlBody(ex, body);
        }
        if (this.isFormData(contentType)) {
            return this.attachFormDataBody(ex, body);
        }
        return false;
    }

    private boolean attachJsonBody(HttpServerExchange ex, String str) {
        if ((str = str.trim()).charAt(0) == '{') {
            this.cacheResponseBody(ex, str);
            return this.parseJsonMapObject(ex, AttachmentConstants.REQUEST_BODY, str);
        }
        if (str.charAt(0) == '[') {
            this.cacheResponseBody(ex, str);
            return this.parseJsonArrayObject(ex, AttachmentConstants.REQUEST_BODY, str);
        }
        this.setExchangeStatus(ex, "ERR10015", ContentType.APPLICATION_JSON.value());
        return false;
    }

    public boolean attachXmlBody(HttpServerExchange ex, String str) {
        this.cacheResponseBody(ex, str);
        return true;
    }

    public boolean attachFormDataBody(HttpServerExchange ex, String str) {
        this.cacheResponseBody(ex, str);
        return true;
    }

    private void cacheResponseBody(HttpServerExchange exchange, String s2) {
        if (this.config.isCacheRequestBody()) {
            exchange.putAttachment(AttachmentConstants.RESPONSE_BODY_STRING, s2);
        }
    }
}

