/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.executionservice.impl;

import com.hazelcast.internal.util.ExceptionUtil;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

public class DelegateAndSkipOnConcurrentExecutionDecorator
implements Runnable {
    private final AtomicBoolean isAlreadyRunning = new AtomicBoolean();
    private final Runnable runnable;
    private final Executor executor;
    private volatile Throwable throwable;

    public DelegateAndSkipOnConcurrentExecutionDecorator(Runnable runnable2, Executor executor) {
        this.runnable = new DelegateDecorator(runnable2);
        this.executor = executor;
    }

    @Override
    public void run() {
        if (this.isAlreadyRunning.compareAndSet(false, true)) {
            if (this.throwable != null) {
                ExceptionUtil.rethrow(this.throwable);
                return;
            }
            this.executor.execute(this.runnable);
        }
    }

    public String toString() {
        return "DelegateAndSkipOnConcurrentExecutionDecorator{isAlreadyRunning=" + this.isAlreadyRunning + ", runnable=" + this.runnable + ", executor=" + this.executor + ", throwable=" + this.throwable + '}';
    }

    private class DelegateDecorator
    implements Runnable {
        private final Runnable runnable;

        DelegateDecorator(Runnable runnable2) {
            this.runnable = runnable2;
        }

        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            catch (Throwable t2) {
                DelegateAndSkipOnConcurrentExecutionDecorator.this.throwable = t2;
            }
            finally {
                DelegateAndSkipOnConcurrentExecutionDecorator.this.isAlreadyRunning.set(false);
            }
        }

        public String toString() {
            return "DelegateDecorator{runnable=" + this.runnable + '}';
        }
    }
}

