/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.impl.operation;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.map.impl.DataCollection;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.replicatedmap.impl.ReplicatedMapService;
import com.hazelcast.replicatedmap.impl.operation.AbstractNamedSerializableOperation;
import com.hazelcast.replicatedmap.impl.record.ReplicatedRecordStore;
import com.hazelcast.spi.impl.operationservice.ReadonlyOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class KeySetOperation
extends AbstractNamedSerializableOperation
implements ReadonlyOperation {
    private String name;
    private transient Object response;

    public KeySetOperation() {
    }

    public KeySetOperation(String name) {
        this.name = name;
    }

    @Override
    public void run() throws Exception {
        ReplicatedMapService service = (ReplicatedMapService)this.getService();
        Collection<ReplicatedRecordStore> stores = service.getAllReplicatedRecordStores(this.name);
        ArrayList keys2 = new ArrayList();
        for (ReplicatedRecordStore store : stores) {
            keys2.addAll(store.keySet(false));
        }
        ArrayList<Data> dataKeys = new ArrayList<Data>(keys2.size());
        SerializationService serializationService = this.getNodeEngine().getSerializationService();
        for (Object key : keys2) {
            dataKeys.add((Data)serializationService.toData(key));
        }
        this.response = new DataCollection(dataKeys);
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeString(this.name);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.name = in.readString();
    }

    @Override
    public int getClassId() {
        return 17;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

