/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.query;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.partition.IPartitionService;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.IterationType;
import com.hazelcast.internal.util.SetUtil;
import com.hazelcast.internal.util.collection.PartitionIdSet;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.QueryResultSizeExceededException;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.query.Query;
import com.hazelcast.map.impl.query.QueryEngine;
import com.hazelcast.map.impl.query.QueryResultSizeLimiter;
import com.hazelcast.map.impl.query.Result;
import com.hazelcast.map.impl.query.ResultProcessorRegistry;
import com.hazelcast.map.impl.query.Target;
import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.Predicates;
import com.hazelcast.query.QueryException;
import com.hazelcast.query.impl.predicates.PagingPredicateImpl;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationService;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

public class QueryEngineImpl
implements QueryEngine {
    public static final HazelcastProperty DISABLE_MIGRATION_FALLBACK = new HazelcastProperty(QueryEngineImpl.class.getName() + ".disableMigrationFallback", false);
    private final MapServiceContext mapServiceContext;
    private final NodeEngine nodeEngine;
    private final ILogger logger;
    private final QueryResultSizeLimiter queryResultSizeLimiter;
    private final IPartitionService partitionService;
    private final OperationService operationService;
    private final ClusterService clusterService;
    private final ResultProcessorRegistry resultProcessorRegistry;
    private final boolean disableMigrationFallback;

    public QueryEngineImpl(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
        this.nodeEngine = mapServiceContext.getNodeEngine();
        this.partitionService = this.nodeEngine.getPartitionService();
        this.logger = this.nodeEngine.getLogger(this.getClass());
        this.queryResultSizeLimiter = new QueryResultSizeLimiter(mapServiceContext, this.logger);
        this.operationService = this.nodeEngine.getOperationService();
        this.clusterService = this.nodeEngine.getClusterService();
        this.resultProcessorRegistry = mapServiceContext.getResultProcessorRegistry();
        this.disableMigrationFallback = this.nodeEngine.getProperties().getBoolean(DISABLE_MIGRATION_FALLBACK);
    }

    public Result execute(Query query, Target target) {
        Query adjustedQuery = this.adjustQuery(query);
        switch (target.mode()) {
            case ALL_NODES: {
                adjustedQuery = Query.of(adjustedQuery).partitionIdSet(this.getAllPartitionIds()).build();
                return this.runOnGivenPartitions(adjustedQuery, adjustedQuery.getPartitionIdSet(), Target.TargetMode.ALL_NODES);
            }
            case LOCAL_NODE: {
                adjustedQuery = Query.of(adjustedQuery).partitionIdSet(this.getLocalPartitionIds()).build();
                return this.runOnGivenPartitions(adjustedQuery, adjustedQuery.getPartitionIdSet(), Target.TargetMode.LOCAL_NODE);
            }
            case PARTITION_OWNER: {
                int solePartition = target.partitions().solePartition();
                adjustedQuery = Query.of(adjustedQuery).partitionIdSet(target.partitions()).build();
                if (solePartition >= 0) {
                    return this.runOnGivenPartition(adjustedQuery, solePartition);
                }
                return this.runOnGivenPartitions(adjustedQuery, adjustedQuery.getPartitionIdSet(), Target.TargetMode.ALL_NODES);
            }
        }
        throw new IllegalArgumentException("Illegal target " + target);
    }

    private Query adjustQuery(Query query) {
        IterationType retrievalIterationType = this.getRetrievalIterationType(query.getPredicate(), query.getIterationType());
        Query.QueryBuilder builder = Query.of(query).iterationType(retrievalIterationType);
        if (query.getPredicate() instanceof PagingPredicateImpl) {
            PagingPredicateImpl clonedPredicate = new PagingPredicateImpl((PagingPredicateImpl)query.getPredicate());
            clonedPredicate.setIterationType(query.getIterationType());
            builder.predicate(clonedPredicate);
        } else if (query.getPredicate() == Predicates.alwaysTrue()) {
            this.queryResultSizeLimiter.precheckMaxResultLimitOnLocalPartitions(query.getMapName());
        }
        return builder.build();
    }

    private Result runOnGivenPartitions(Query query, PartitionIdSet partitions, Target.TargetMode targetMode) {
        Result result = this.doRunOnQueryThreads(query, partitions, targetMode);
        if (!this.disableMigrationFallback && this.isResultFromAnyPartitionMissing(partitions)) {
            this.doRunOnPartitionThreads(query, partitions, result);
        }
        this.assertAllPartitionsQueried(partitions);
        return result;
    }

    private Result runOnGivenPartition(Query query, int partitionId) {
        try {
            return this.dispatchPartitionScanQueryOnOwnerMemberOnPartitionThread(query, partitionId).get();
        }
        catch (Throwable t2) {
            throw ExceptionUtil.rethrow(t2);
        }
    }

    private Result doRunOnQueryThreads(Query query, PartitionIdSet partitionIds, Target.TargetMode targetMode) {
        Result result = this.populateResult(query);
        List<Future<Result>> futures = this.dispatchOnQueryThreads(query, targetMode);
        this.addResultsOfPredicate(futures, result, partitionIds, this.disableMigrationFallback);
        return result;
    }

    private List<Future<Result>> dispatchOnQueryThreads(Query query, Target.TargetMode targetMode) {
        try {
            return this.dispatchFullQueryOnQueryThread(query, targetMode);
        }
        catch (Throwable t2) {
            if (!(t2 instanceof HazelcastException)) {
                throw ExceptionUtil.rethrow(t2);
            }
            if (t2.getCause() instanceof QueryResultSizeExceededException) {
                throw ExceptionUtil.rethrow(t2);
            }
            if (this.disableMigrationFallback) {
                throw ExceptionUtil.rethrow(t2);
            }
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Query invocation failed on member ", t2);
            }
            return Collections.emptyList();
        }
    }

    private Result populateResult(Query query) {
        return this.resultProcessorRegistry.get(query.getResultType()).populateResult(query, this.queryResultSizeLimiter.getNodeResultLimit(query.getPartitionIdSet().size()));
    }

    private void doRunOnPartitionThreads(Query query, PartitionIdSet partitionIds, Result result) {
        try {
            List<Future<Result>> futures = this.dispatchPartitionScanQueryOnOwnerMemberOnPartitionThread(query, partitionIds);
            this.addResultsOfPredicate(futures, result, partitionIds, true);
        }
        catch (Throwable t2) {
            throw ExceptionUtil.rethrow(t2);
        }
    }

    private void addResultsOfPredicate(List<Future<Result>> futures, Result result, PartitionIdSet unfinishedPartitionIds, boolean rethrowAll) {
        for (Future<Result> future : futures) {
            PartitionIdSet queriedPartitionIds;
            Result queryResult = null;
            try {
                queryResult = future.get();
            }
            catch (Throwable t2) {
                if (t2.getCause() instanceof QueryResultSizeExceededException || rethrowAll) {
                    throw ExceptionUtil.rethrow(t2);
                }
                this.logger.fine("Could not get query results", t2);
            }
            if (queryResult == null || (queriedPartitionIds = queryResult.getPartitionIds()) == null || !unfinishedPartitionIds.containsAll(queriedPartitionIds)) continue;
            unfinishedPartitionIds.removeAll(queriedPartitionIds);
            result.combine(queryResult);
        }
    }

    private void assertAllPartitionsQueried(PartitionIdSet mutablePartitionIds) {
        if (this.isResultFromAnyPartitionMissing(mutablePartitionIds)) {
            throw new QueryException("Query aborted. Could not execute query for all partitions. Missed " + mutablePartitionIds.size() + " partitions");
        }
    }

    private IterationType getRetrievalIterationType(Predicate predicate, IterationType iterationType) {
        IterationType retrievalIterationType = iterationType;
        if (predicate instanceof PagingPredicate) {
            PagingPredicate pagingPredicate = (PagingPredicate)predicate;
            retrievalIterationType = pagingPredicate.getComparator() != null ? IterationType.ENTRY : (iterationType == IterationType.VALUE ? IterationType.ENTRY : iterationType);
        }
        return retrievalIterationType;
    }

    private PartitionIdSet getLocalPartitionIds() {
        int partitionCount = this.partitionService.getPartitionCount();
        List<Integer> memberPartitions = this.partitionService.getMemberPartitions(this.nodeEngine.getThisAddress());
        return new PartitionIdSet(partitionCount, memberPartitions);
    }

    PartitionIdSet getAllPartitionIds() {
        int partitionCount = this.partitionService.getPartitionCount();
        return SetUtil.allPartitionIds(partitionCount);
    }

    private boolean isResultFromAnyPartitionMissing(PartitionIdSet unfinishedPartitionIds) {
        return !unfinishedPartitionIds.isEmpty();
    }

    protected QueryResultSizeLimiter getQueryResultSizeLimiter() {
        return this.queryResultSizeLimiter;
    }

    protected List<Future<Result>> dispatchFullQueryOnQueryThread(Query query, Target.TargetMode targetMode) {
        switch (targetMode) {
            case ALL_NODES: {
                return this.dispatchFullQueryOnAllMembersOnQueryThread(query);
            }
            case LOCAL_NODE: {
                return this.dispatchFullQueryOnLocalMemberOnQueryThread(query);
            }
        }
        throw new IllegalArgumentException("Illegal target " + query);
    }

    private List<Future<Result>> dispatchFullQueryOnLocalMemberOnQueryThread(Query query) {
        Operation operation = this.mapServiceContext.getMapOperationProvider(query.getMapName()).createQueryOperation(query);
        InvocationFuture result = this.operationService.invokeOnTarget("hz:impl:mapService", operation, this.nodeEngine.getThisAddress());
        return Collections.singletonList(result);
    }

    private List<Future<Result>> dispatchFullQueryOnAllMembersOnQueryThread(Query query) {
        Collection<Address> members;
        if (query.getPartitionIdSet().size() == this.partitionService.getPartitionCount()) {
            members = this.clusterService.getMembers(MemberSelectors.DATA_MEMBER_SELECTOR).stream().map(m4 -> m4.getAddress()).collect(Collectors.toList());
        } else {
            members = new HashSet();
            PrimitiveIterator.OfInt iterator2 = query.getPartitionIdSet().intIterator();
            while (iterator2.hasNext()) {
                members.add(this.partitionService.getPartitionOwnerOrWait(iterator2.next()));
            }
        }
        ArrayList<Future<Result>> futures = new ArrayList<Future<Result>>(members.size());
        for (Address address : members) {
            Operation operation = this.createQueryOperation(query);
            InvocationFuture future = this.operationService.invokeOnTarget("hz:impl:mapService", operation, address);
            futures.add(future);
        }
        return futures;
    }

    private Operation createQueryOperation(Query query) {
        return this.mapServiceContext.getMapOperationProvider(query.getMapName()).createQueryOperation(query);
    }

    protected List<Future<Result>> dispatchPartitionScanQueryOnOwnerMemberOnPartitionThread(Query query, PartitionIdSet partitionIds) {
        if (QueryEngineImpl.shouldSkipPartitionsQuery(partitionIds)) {
            return Collections.emptyList();
        }
        ArrayList<Future<Result>> futures = new ArrayList<Future<Result>>(partitionIds.size());
        partitionIds.intIterator().forEachRemaining(partitionId -> futures.add(this.dispatchPartitionScanQueryOnOwnerMemberOnPartitionThread(query, partitionId)));
        return futures;
    }

    protected Future<Result> dispatchPartitionScanQueryOnOwnerMemberOnPartitionThread(Query query, int partitionId) {
        Operation op = this.createQueryPartitionOperation(query);
        op.setPartitionId(partitionId);
        try {
            return this.operationService.invokeOnPartition("hz:impl:mapService", op, partitionId);
        }
        catch (Throwable t2) {
            throw ExceptionUtil.rethrow(t2);
        }
    }

    private Operation createQueryPartitionOperation(Query query) {
        return this.mapServiceContext.getMapOperationProvider(query.getMapName()).createQueryPartitionOperation(query);
    }

    private static boolean shouldSkipPartitionsQuery(PartitionIdSet partitionIds) {
        return partitionIds == null || partitionIds.isEmpty();
    }
}

