/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation.steps;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.internal.partition.IPartitionService;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapEntries;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.operation.EntryOperator;
import com.hazelcast.map.impl.operation.steps.DeleteOpSteps;
import com.hazelcast.map.impl.operation.steps.EntryOpSteps;
import com.hazelcast.map.impl.operation.steps.IMapOpStep;
import com.hazelcast.map.impl.operation.steps.PutOpSteps;
import com.hazelcast.map.impl.operation.steps.UtilSteps;
import com.hazelcast.map.impl.operation.steps.engine.State;
import com.hazelcast.map.impl.operation.steps.engine.Step;
import com.hazelcast.map.impl.recordstore.DefaultRecordStore;
import com.hazelcast.map.impl.recordstore.RecordStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public enum MultipleEntryOpSteps implements IMapOpStep
{
    FIND_KEYS_TO_LOAD{

        @Override
        public void runStep(State state) {
            RecordStore recordStore = state.getRecordStore();
            IPartitionService partitionService = recordStore.getMapContainer().getMapServiceContext().getNodeEngine().getPartitionService();
            ArrayList<Data> keysToLoad = new ArrayList<Data>();
            Collection<Data> keys2 = state.getKeys();
            for (Data key : keys2) {
                if (partitionService.getPartitionId(key) != state.getPartitionId() || recordStore.getRecord(key) != null) continue;
                keysToLoad.add(key);
            }
            if (!keysToLoad.isEmpty()) {
                state.setKeysToLoad(keysToLoad);
            }
        }

        @Override
        public Step nextStep(State state) {
            if (!state.getKeysToLoad().isEmpty()) {
                return LOAD_ALL;
            }
            return PROCESS;
        }
    }
    ,
    LOAD_ALL{

        @Override
        public boolean isLoadStep() {
            return true;
        }

        @Override
        public void runStep(State state) {
            Collection<Data> keysToLoad = state.getKeysToLoad();
            Map loadedKeyValuePairs = state.getRecordStore().getMapDataStore().loadAll(keysToLoad);
            state.setLoadedKeyValuePairs(loadedKeyValuePairs);
        }

        @Override
        public Step nextStep(State state) {
            return state.getLoadedKeyValuePairs().isEmpty() ? PROCESS : ON_LOAD_ALL;
        }
    }
    ,
    ON_LOAD_ALL{

        @Override
        public void runStep(State state) {
            RecordStore recordStore = state.getRecordStore();
            MapContainer mapContainer = recordStore.getMapContainer();
            MapServiceContext mapServiceContext = mapContainer.getMapServiceContext();
            Map loadedKeyValuePairs = state.getLoadedKeyValuePairs();
            for (Map.Entry entry : loadedKeyValuePairs.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (key == null || value == null) continue;
                ((DefaultRecordStore)recordStore).onLoadRecord(mapServiceContext.toData(key), value, false, state.getCallerAddress());
            }
        }

        @Override
        public Step nextStep(State state) {
            return PROCESS;
        }
    }
    ,
    PROCESS{

        @Override
        public void runStep(State state) {
            RecordStore recordStore = state.getRecordStore();
            ArrayList<State> toStore = new ArrayList<State>();
            ArrayList<State> toRemove = new ArrayList<State>();
            state.setToStore(toStore);
            state.setToRemove(toRemove);
            MapEntries responses = new MapEntries(state.getKeys().size());
            state.setResult(responses);
            Collection<Data> keys2 = state.getKeys();
            block4: for (Data key : keys2) {
                Object record = recordStore.getRecord(key);
                State singleKeyState = new State(state);
                singleKeyState.setKey(key).setOldValue(record == null ? null : record.getValue()).setEntryOperator(EntryOperator.operator(state.getOperation(), state.getEntryProcessor(), state.getPredicate()));
                EntryOpSteps.PROCESS.runStep(singleKeyState);
                EntryOpSteps.DO_POST_OPERATE_OPS.runStep(singleKeyState);
                EntryEventType eventType = singleKeyState.getOperator().getEventType();
                if (eventType == null) {
                    Data result = singleKeyState.getOperator().getResult();
                    if (result == null) continue;
                    responses.add(singleKeyState.getKey(), result);
                    continue;
                }
                switch (eventType) {
                    case ADDED: 
                    case UPDATED: {
                        toStore.add(singleKeyState);
                        continue block4;
                    }
                    case REMOVED: {
                        toRemove.add(singleKeyState);
                        continue block4;
                    }
                }
                throw new IllegalArgumentException("Unexpected event found:" + (Object)((Object)eventType));
            }
        }

        @Override
        public Step nextStep(State state) {
            return !state.getToStore().isEmpty() || !state.getToRemove().isEmpty() ? STORE_OR_DELETE : ON_STORE_OR_DELETE;
        }
    }
    ,
    STORE_OR_DELETE{

        @Override
        public boolean isStoreStep() {
            return true;
        }

        @Override
        public void runStep(State state) {
            List<State> toStore = state.getToStore();
            for (State s2 : toStore) {
                PutOpSteps.STORE.runStep(s2);
            }
            List<State> toRemove = state.getToRemove();
            for (State s3 : toRemove) {
                DeleteOpSteps.DELETE.runStep(s3);
            }
        }

        @Override
        public Step nextStep(State state) {
            return ON_STORE_OR_DELETE;
        }
    }
    ,
    ON_STORE_OR_DELETE{

        @Override
        public void runStep(State state) {
            List<State> toStore = state.getToStore();
            for (State s2 : toStore) {
                PutOpSteps.ON_STORE.runStep(s2);
                EntryOperator operator = s2.getOperator();
                operator.onAddedOrUpdated0(s2.getNewValue());
                operator.doPostOperateOps0();
                Data result = s2.getOperator().getResult();
                if (result == null) continue;
                ((MapEntries)state.getResult()).add(s2.getKey(), result);
            }
            List<State> toRemove = state.getToRemove();
            for (State s3 : toRemove) {
                DeleteOpSteps.ON_DELETE.runStep(s3);
                EntryOperator operator = s3.getOperator();
                operator.onRemove0();
                operator.doPostOperateOps0();
                Data result = s3.getOperator().getResult();
                if (result == null) continue;
                ((MapEntries)state.getResult()).add(s3.getKey(), result);
            }
        }

        @Override
        public Step nextStep(State state) {
            return UtilSteps.FINAL_STEP;
        }
    };

}

